% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllometricFunctions.R
\name{surface_area_from_mass}
\alias{surface_area_from_mass}
\title{Organism Surface Area from Mass}
\usage{
surface_area_from_mass(m, taxon)
}
\arguments{
\item{m}{\code{numeric} vector of mass (g).}

\item{taxon}{\code{character} taxonomic classification of organism, current choices: \code{"lizard"}, \code{"salamander"}, \code{"frog"}, \code{"insect"}.}
}
\value{
\code{numeric} surface area (\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}).
}
\description{
The function estimates surface area (\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}) from mass (g) for one of a variety of taxa.
}
\details{
All models follow (\ifelse{html}{\out{SA = a M<sup>b</sup>}}{\eqn{SA = a M^b}{ASCII}}) with mass in grams and surface area in \ifelse{html}{\out{meters<sup>2</sup>}}{\eqn{meters^2}{ASCII}}.
\cr
 \itemize{
  \item Lizards \insertCite{Norris1965,Porter1979,Roughgarden1981,OConnor1999,Fei2012}{TrenchR}:
    \cr 
    \cr \eqn{a = 0.000314 \pi} 
    \cr \eqn{b = 2/3}
  \item Salamanders \insertCite{Whitford1967,Riddell2017}{TrenchR}:
    \cr 
    \cr \eqn{a = 0.000842} 
    \cr \eqn{b = 0.694}
  \item Frogs \insertCite{McClanahan1969}{TrenchR}:
    \cr 
    \cr \eqn{a = 0.00099} 
    \cr \eqn{b = 0.56}
  \item Insects \insertCite{Lactin1997}{TrenchR}:
    \cr 
    \cr \eqn{a = 0.0013} 
    \cr \eqn{b = 0.8}
 }
}
\examples{
  surface_area_from_mass(m     = 1:50, 
                         taxon = "lizard")
  surface_area_from_mass(m     = 1:50,  
                         taxon = "salamander")
  surface_area_from_mass(m     = 1:50,  
                         taxon = "frog")
  surface_area_from_mass(m     = seq(0.1, 5, 0.1),  
                         taxon = "insect")

}
\references{
\insertAllCited{}
}
\seealso{
Other allometric functions: 
\code{\link{mass_from_length}()},
\code{\link{proportion_silhouette_area_shapes}()},
\code{\link{proportion_silhouette_area}()},
\code{\link{surface_area_from_length}()},
\code{\link{surface_area_from_volume}()},
\code{\link{volume_from_length}()}
}
\concept{allometric functions}
