% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{SplitMutualInformation}
\alias{SplitMutualInformation}
\alias{SplitVariationOfInformation}
\alias{TreesConsistentWithTwoSplits}
\alias{LogTreesConsistentWithTwoSplits}
\title{Mutual information of two splits}
\usage{
SplitMutualInformation(n, A1, A2 = A1)

SplitVariationOfInformation(n, A1, A2 = A1)

TreesConsistentWithTwoSplits(n, A1, A2 = A1)

LogTreesConsistentWithTwoSplits(n, A1, A2 = A1)
}
\arguments{
\item{n}{Integer specifying the number of terminals.}

\item{A1, A2}{Integers specifying the number of taxa in \emph{A1} and \emph{A2},
once the splits have been arranged such that \emph{A1} overlaps with \emph{A2}.}
}
\value{
\code{TreesConsistentWithTwoSplits} returns the number of unrooted bifurcating
trees consistent with two splits.

\code{SplitMutualInformation} returns the information that two splits
have in common, in bits.

\code{SplitVariationOfInformation} returns the variation of information (Meila 2007)
between the two splits, a measure of their difference, in bits.
}
\description{
Reports the mutual phylogenetic information, or variation of phylogenetic
information, of two splits.
}
\details{
The mutual phylogenetic information corresponds to the entropy of the subset
of trees consistent with both splits; two splits that are consistent with a
smaller number of trees will have a higher mutual information content.

Split 1 divides \code{n} terminals into two partitions, \emph{A1} and \emph{B1}.
Split 2 divides the same terminals into the partitions \emph{A2} and \emph{B2}.

Partitions must be named such that \emph{A1} overlaps with \emph{A2}: that is to say,
all taxa in \emph{A1} are also in \emph{A2}, or \emph{vice versa}.  Thus, all taxa in
the smaller of \emph{A1} and \emph{A2} also occur in the larger.
}
\section{Functions}{
\itemize{
\item \code{SplitVariationOfInformation}: Variation of information between two splits.

\item \code{TreesConsistentWithTwoSplits}: Number of trees consistent with two splits.

\item \code{LogTreesConsistentWithTwoSplits}: Natural logarithm of \code{TreesConsistentWithTwoSplits}.
}}

\examples{
  # Eight tips, labelled A to H.
  # Split 1: ABCD:EFGH
  # Split 2: ABC:DEFGH
  # Let A1 = ABCD (four taxa), and A2 = ABC (three taxa).
  # A1 and A2 overlap (both contain ABC).
  
  TreesConsistentWithTwoSplits(n=8, A1=4, A2=3)
  SplitMutualInformation(n=8, A1=4, A2=3)
  SplitVariationOfInformation(n=8, A1=4, A2=3)

  # If splits are identical, then their mutual information is the same
  # as the information of either split:
  SplitMutualInformation(n=8, A1=3, A2=3)
  SplitInformation(3, 5)
  
}
\references{
\insertRef{Meila2007}{TreeSearch}
}
\author{
Martin R. Smith
}
\concept{Split information}
