% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/median.R
\encoding{UTF-8}
\name{median.multiPhylo}
\alias{median.multiPhylo}
\title{Median of a set of trees}
\usage{
\method{median}{multiPhylo}(
  x,
  na.rm = FALSE,
  Distance = ClusteringInfoDistance,
  index = FALSE,
  breakTies = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{multiPhylo} containing phylogenetic trees.}

\item{na.rm, \dots}{Unused; included for consistency with default function..}

\item{Distance}{Function to calculate distances between each pair
of trees in \code{x}.}

\item{index}{Logical: if \code{TRUE}, return the index of the median tree(s);
if \code{FALSE}, return the tree itself.}

\item{breakTies}{Logical: if \code{TRUE}, return a single tree with the minimum
score; if \code{FALSE}, return all tied trees.}
}
\value{
\code{median()} returns an object of class \code{phylo}
corresponding to the geometric median of a set of trees:
that is, the tree whose average distance from all other trees in the set
is lowest.
If multiple trees tie in their average distance, the first will be returned,
unless \code{breakTies = FALSE}, in which case an object of class \code{multiPhylo}
containing all such trees will be returned.
}
\description{
Calculate the single binary tree that represents the geometric median --
an 'average' -- of a forest of tree topologies.
}
\details{
The geometric median is the tree that exhibits the shortest average distance
from each other tree topology in the set.
It represents an 'average' of a set of trees, though note that an unsampled
tree may be closer to the geometric 'centre of gravity' of the input set --
such a tree would not be considered.

The result will depend on the metric chosen to calculate distances between
tree topologies. In the absence of a natural metric of tree topologies,
the default choice is \code{\link[=ClusteringInfoDistance]{ClusteringInfoDistance()}} -- which discards
branch length information.
If specifying a different function, be sure that it returns a difference,
rather than a similarity.
}
\examples{
library('TreeTools', quietly = TRUE, warn.conflicts = FALSE)
tenTrees <- as.phylo(1:10, nTip = 8)

# Default settings:
median(tenTrees)

# Robinson-Foulds distances include ties:
median(tenTrees, Distance = RobinsonFoulds, breakTies = FALSE)

# Be sure to use a distance function, rather than a similarity:
NyeDistance <- function(...) NyeSimilarity(..., similarity = FALSE)
median(tenTrees, Distance = NyeDistance)

# To analyse a list of trees that is not of class multiPhylo:
treeList <- lapply(1:10, as.phylo, nTip = 8)
class(treeList)
median(structure(treeList, class = 'multiPhylo'))
}
\seealso{
Consensus methods:
\code{\link[ape:consensus]{ape::consensus()}},
\code{\link[TreeTools:ConsensusWithout]{TreeTools::ConsensusWithout()}}

Other tree space functions: 
\code{\link{MapTrees}()},
\code{\link{MappingQuality}()},
\code{\link{SpectralEigens}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree space functions}
