% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CircosFruits.R
\name{create_base_plot}
\alias{create_base_plot}
\title{Create a base plot with gene expression data on a phylogenetic tree}
\usage{
create_base_plot(p, data, gene_colors, gene_label = "Gene")
}
\arguments{
\item{p}{A ggtree plot object to which the data will be added.}

\item{data}{A data frame containing gene expression data with columns for Samples, Genes, and Values.}

\item{gene_colors}{A named vector of colors for genes.}

\item{gene_label}{A character string used as a label in the legend for the genes. Default is "Gene".}
}
\value{
A `ggtree` plot object with the gene expression data added.
}
\description{
This function creates a base plot using 'ggtree' and 'ggtreeExtra' libraries, adding gene expression
data as colored tiles to the plot. It allows for dynamic coloring of the genes and includes
adjustments for alpha transparency based on the expression value.
}
\examples{
\donttest{
# Check and load required packages
if (requireNamespace("ggtreeExtra", quietly = TRUE) &&
 requireNamespace("ggplot2", quietly = TRUE)) {
  library(ggtreeExtra)
  library(ggplot2)

  file_path <- system.file("extdata", "p_tree_test.rds", package = "TransProR")
  p <- readRDS(file_path)

  # Create gene expression data frame
  expression_data <- data.frame(
    Sample = rep(c("Species_A", "Species_B", "Species_C", "Species_D"), each = 5),
    Gene = rep(paste0("Gene", 1:5), times = 4),
    Value = runif(20, min = 0, max = 1)  # Randomly generate expression values between 0 and 1
  )

  # Define gene colors (named vector)
  gene_colors <- c(
    Gene1 = "#491588",
    Gene2 = "#301b8d",
    Gene3 = "#1a237a",
    Gene4 = "#11479c",
    Gene5 = "#0a5797"
  )

  # Call create_base_plot function to add gene expression data
  p <- create_base_plot(p, expression_data, gene_colors)
} else {
  message("Required packages 'ggtreeExtra' and 'ggplot2' are not installed.")
}
}

}
