% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpeedCluster.R
\docType{methods}
\name{speedCluster}
\alias{speedCluster}
\alias{speedCluster,Track,numeric,numeric,numeric-method}
\title{Speed Cluster}
\usage{
speedCluster(track, avg, minT, sl)

\S4method{speedCluster}{Track,numeric,numeric,numeric}(track, avg, minT, sl)
}
\arguments{
\item{track}{Represents a single trajectory followed by a person, animal or object}

\item{avg}{Is the average speed of track}

\item{minT}{Is the minimun period at the speed of track}

\item{sl}{Is the speed limit of track}
}
\value{
Returns regions where speed was lower than the defined parameter
}
\description{
Method for check the regions where speed was lower than the defined parameter
}
\details{
Order the speed so it will start with the slowest speed cluster
}
\examples{
avgSpeed <- mean(A1@connections$speed)

minSpeed <- min(A1@connections$speed)

speed <- speedCluster(A1,avgSpeed,minSpeed,586)
}
\author{
Diego Monteiro
}
