% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_bindings.R
\name{set_precision_data}
\alias{set_precision_data}
\title{Set precision data}
\usage{
set_precision_data(layer, prec, default = c("error", "auto"))
}
\arguments{
\item{layer}{A \code{tplyr_layer} object}

\item{prec}{A dataframe following the structure specified in the function details}

\item{default}{Handling of unspecified by variable groupings. Defaults to 'error'. Set to 'auto' to automatically infer any missing groups.}
}
\description{
In some cases, there may be organizational standards surrounding decimal precision.
For example, there may be a specific standard around the representation of precision relating
to lab results. As such, \code{set_precision_data()} provides an interface to provide integer and
decimal precision from an external data source.
}
\details{
The ultimate behavior of this feature is just that of the existing auto precision method, except
that the precision is specified in the provided precision dataset rather than inferred from the source data.
At a minimum, the precision dataset must contain the integer variables \code{max_int} and \code{max_dec}. If by variables
are provided, those variables must be available in the layer by variables.

When the table is built, by default Tplyr will error if the precision dataset is missing by variable groupings
that exist in the target dataset. This can be overriden using the \code{default} parameter. If \code{default} is set to
"auto", any missing values will be automatically inferred from the source data.
}
\examples{

prec <- tibble::tribble(
  ~vs, ~max_int, ~max_dec,
  0,        1,        1,
  1,        2,        2
)

tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_desc(wt, by = vs) \%>\%
      set_format_strings(
        'Mean (SD)' = f_str('a.a+1 (a.a+2)', mean, sd)
      ) \%>\%
      set_precision_data(prec) \%>\%
      set_precision_on(wt)
  ) \%>\%
  build()

}
