% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lowestnonzero}
\alias{lowestnonzero}
\title{Lowest nonzero values}
\usage{
lowestnonzero(x)
}
\arguments{
\item{x}{A vector of p-values between 0 and 1.}
}
\value{
A vector of p-values where zero values are exchanged for the lowest non-zero p-value in the original vector.
}
\description{
Sometimes want to plot p-values (e.g., volcano plot or MA-plot), but if a
statistical test returns a zero p-value, this causes problems with
visualization on the log scale. This function returns a vector where  the
zero values are equal to the smallest nonzero value in the vector.
}
\examples{
lowestnonzero(c(.042, .02, 0, .001, 0, .89))

}
