% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-helpers-visualization.R
\name{plot_zones_interactive}
\alias{plot_zones_interactive}
\title{Generate interactive plot of polygons with leaflet}
\usage{
plot_zones_interactive(
  polygons,
  coastline,
  title,
  colors,
  show_legend = TRUE,
  labels = NULL,
  base_layers = TRUE,
  minimap = TRUE
)
}
\arguments{
\item{polygons}{List of polygons. Each must have fields such as coords, announcement, dates and coordinates.}

\item{coastline}{Data frame with the coastline (columns Long and Lat).}

\item{title}{Title to display at the top of the map.}

\item{colors}{Vector of colors. If NULL, they are automatically assigned with RColorBrewer::brewer.pal.}

\item{show_legend}{Logical. If TRUE, the layers control (legend) is displayed.}

\item{labels}{Optional vector of names to display in the legend and map labels.}

\item{base_layers}{Logical. If TRUE, includes base layers such as satellite and ocean maps.}

\item{minimap}{Logical. If TRUE, displays a minimap in the lower right corner.}
}
\value{
A leaflet object with the interactive map.
}
\description{
Creates an interactive map using leaflet, showing polygons with popup information.
}
\keyword{internal}
