% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-mcmc-sampling.R
\name{tidy_mcmc_sampling}
\alias{tidy_mcmc_sampling}
\title{Tidy MCMC Sampling}
\usage{
tidy_mcmc_sampling(.x, .fns = "mean", .cum_fns = "cmean", .num_sims = 2000)
}
\arguments{
\item{.x}{The data vector for MCMC sampling.}

\item{.fns}{The function(s) to apply to each MCMC sample. Default is "mean".}

\item{.cum_fns}{The function(s) to apply to the cumulative MCMC samples. Default is "cmean".}

\item{.num_sims}{The number of simulations. Default is 2000.}
}
\value{
A list containing tidy data and a plot.
}
\description{
This function performs Markov Chain Monte Carlo (MCMC) sampling on the input
data and returns tidy data and a plot representing the results.
}
\details{
Perform MCMC sampling and return tidy data and a plot.

The function takes a data vector as input and performs MCMC sampling with the
specified number of simulations. It applies user-defined functions to each
MCMC sample and to the cumulative MCMC samples. The resulting data is
formatted in a tidy format, suitable for further analysis. Additionally, a
plot is generated to visualize the MCMC samples and cumulative statistics.
}
\examples{
# Generate MCMC samples
set.seed(123)
data <- rnorm(100)
result <- tidy_mcmc_sampling(data, "median", "cmedian", 500)
result

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
