% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitDF.R
\name{matchDF}
\alias{matchDF}
\title{Match Rows of \link[base]{data.frame}s}
\usage{
matchDF(
  x,
  table = unique.data.frame(x),
  by = names(x),
  by.x = character(),
  by.table = character()
)
}
\arguments{
\item{x}{\link[base]{data.frame}, the rows of which to be matched.}

\item{table}{\link[base]{data.frame}, the rows of which to be matched \emph{against}.}

\item{by}{\link[base]{character} scalar or \link[base]{vector}}

\item{by.x, by.table}{\link[base]{character} scalar or \link[base]{vector}}
}
\value{
Function \link{matchDF} returns a \link[base]{integer} \link[base]{vector}
}
\description{
To \link[base]{match} the rows of one \link[base]{data.frame}
to the rows of another \link[base]{data.frame}.
}
\examples{
DF <- swiss[sample(nrow(swiss), size = 100, replace = TRUE), ]
matchDF(DF)

}
