chcemat_simulate <- function(index.pop, SfdList) {
#  chceimatSIMULATE generates an Nindex.pop by N matrix of random score index
#  values for N test questions and Nindex.pop values of index.pop
#  located at the score index values in SCRFINE.
#  The probabilities for each question are generated by interpolation
#  over the score values in SCRFINE of the probabilities in the MI
#  columns of matrix Pmati.

#  Last modified on 15 December 2023 by Jim Ramsay

  nfine   <- 101
  n       <- length(SfdList)
  indfine <- seq(0,100,len=101)
  nindex.pop <- length(index.pop)
  SList1 <- SfdList[[1]]
  Pmat1  <- SList1$Pmatfine
  scrmin <-   0
  scrmax <- 100
  if (any(index.pop < scrmin) || any(index.pop > scrmax)) {
    stop("Values in index.pop out of score index range.")
  }
  chceimatmat <- matrix(0,nindex.pop,n)
  for (i in 1:n) {
    SListi <- SfdList[[i]]
    Mi     <- SListi$M
    Pmati  <- SListi$Pmatfine
    for (j in 1:nindex.pop) {
      prob = matrix(0,1,Mi)
      for (m in 1:Mi) {
        prob[m]  <- pracma::interp1(indfine, Pmati[,m], index.pop[j])
      }
      prob  <- prob/apply(prob, 1, sum)
      if (any(prob < 0) || any(prob > 1)) {
        print(c(j,i,prob))
        stop("prob < 0 || prob > 1")
      }
      uval <- matrix(rmultinom(1,1,prob),1,Mi)
      if (!is.numeric(uval)) { 
        print(uval)
        print(prob)
        print(sum(prob)-1)
        stop("bad value for prob")
      }
      m  <- (1:Mi)[uval==1]
      if (m < 1 || m > Mi) {
        print(c(j,i,m))
        stop("m < 1 || m > Mi")
      }
      chceimatmat[j,i] <- m
    }
  }
  
  return(chceimatmat) 
  
}