% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sum.R
\name{extract_sum}
\alias{extract_sum}
\title{Summary Statistics Extraction}
\usage{
extract_sum(x, Sex = 1, Pop = 2, firstX = 3, test = "tg", run = TRUE, ...)
}
\arguments{
\item{x}{Data frame of raw data.}

\item{Sex}{Number of the column containing sex 'M' for male and 'F' for
female, Default: 1}

\item{Pop}{Number of the column containing populations' names, Default: 2}

\item{firstX}{Number of column containing measured parameters (First of
multiple in case of multivariate analysis), Default: 3}

\item{test}{`tg` for Greene t test \link{t_greene}, `uni` for
\link{univariate}, `aov` for sex specific ANOVA \link{aov_ss},
`multi` for \link{multivariate}, and `van`  for \link{van_vark},
Default: 1}

\item{run}{Logical; if TRUE runs the corresponding test after data
extraction, Default:TRUE}

\item{...}{Additional arguments that could be passed to the test of choice}
}
\value{
Input for other functions.
}
\description{
Extract summary data needed for other functions from raw data.
}
\details{
Raw data is entered in a wide format data frame similar to
\link{Howells} data set. The first two columns contain sex `Sex`
(`M` for male and `F` for female) (Default: `1`) and populations' names `Pop`
(Default:`2`). Starting from `firstX` column (Default: `3`), measured
parameters are entered each in a separate column.
}
\examples{
# for multivariate test
\dontrun{
extract_sum(Howells, test = "multi")
# for univariate test on a specific parameter
extract_sum(Howells, test = "uni", firstX = 4)
}
}
