% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_class.R
\docType{class}
\name{item-classes}
\alias{item-classes}
\alias{item}
\alias{item_1PL-class}
\alias{item_2PL-class}
\alias{item_3PL-class}
\alias{item_PC-class}
\alias{item_GPC-class}
\alias{item_GR-class}
\title{Item classes}
\description{
\itemize{
  \item{\code{\linkS4class{item_1PL}} class represents a 1PL item.}
  \item{\code{\linkS4class{item_2PL}} class represents a 2PL item.}
  \item{\code{\linkS4class{item_3PL}} class represents a 3PL item.}
  \item{\code{\linkS4class{item_PC}} class represents a partial credit item.}
  \item{\code{\linkS4class{item_GPC}} class represents a generalized partial credit item.}
  \item{\code{\linkS4class{item_GR}} class represents a graded response item.}
}
}
\section{Slots}{

\describe{
\item{\code{slope}}{a slope parameter value}

\item{\code{difficulty}}{a difficulty parameter value}

\item{\code{guessing}}{a guessing parameter value}

\item{\code{threshold}}{a vector of threshold parameter values}

\item{\code{category}}{a vector of category boundary values}

\item{\code{ncat}}{the number of response categories}
}}

\examples{
item_1 <- new("item_1PL", difficulty = 0.5)
item_2 <- new("item_2PL", slope = 1.0, difficulty = 0.5)
item_3 <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
item_4 <- new("item_PC", threshold = c(-0.5, 0.5), ncat = 3)
item_5 <- new("item_GPC", slope = 1.0, threshold = c(-0.5, 0.0, 0.5), ncat = 4)
item_6 <- new("item_GR", slope = 1.0, category = c(-2.0, -1.0, 0, 1.0, 2.0), ncat = 6)

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397–479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149–174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561–573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159–176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
