% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_functions.R, R/shadow_functions.R
\docType{methods}
\name{simResp}
\alias{simResp}
\alias{simResp,item_1PL,numeric-method}
\alias{simResp,item_2PL,numeric-method}
\alias{simResp,item_3PL,numeric-method}
\alias{simResp,item_PC,numeric-method}
\alias{simResp,item_GPC,numeric-method}
\alias{simResp,item_GR,numeric-method}
\alias{simResp,item_pool,numeric-method}
\alias{simResp,pool_cluster,numeric-method}
\alias{simResp,pool_cluster,list-method}
\title{Simulate item responses}
\usage{
simResp(object, theta)

\S4method{simResp}{item_1PL,numeric}(object, theta)

\S4method{simResp}{item_2PL,numeric}(object, theta)

\S4method{simResp}{item_3PL,numeric}(object, theta)

\S4method{simResp}{item_PC,numeric}(object, theta)

\S4method{simResp}{item_GPC,numeric}(object, theta)

\S4method{simResp}{item_GR,numeric}(object, theta)

\S4method{simResp}{item_pool,numeric}(object, theta)

\S4method{simResp}{pool_cluster,numeric}(object, theta)

\S4method{simResp}{pool_cluster,list}(object, theta)

\S4method{simResp}{pool_cluster,list}(object, theta)
}
\arguments{
\item{object}{An instance of an item class.}

\item{theta}{A vector of theta values.}
}
\value{
Simulated responses.
}
\description{
An S4 generic and its methods to simulate responses.
}
\examples{
item_1     <- new("item_1PL", difficulty = 0.5)
sim_item_1 <- simResp(item_1, seq(-3, 3, 1))
item_2     <- new("item_2PL", slope = 1.0, difficulty = 0.5)
sim_item_2 <- simResp(item_2, seq(-3, 3, 1))
item_3     <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
sim_item_3 <- simResp(item_3, seq(-3, 3, 1))
item_4     <- new("item_PC", threshold = c(-1, 0, 1), ncat = 4)
sim_item_4 <- simResp(item_4, seq(-3, 3, 1))
item_5     <- new("item_GPC", slope = 1.2, threshold = c(-0.8, -1.0, 0.5), ncat = 4)
sim_item_5 <- simResp(item_5, seq(-3, 3, 1))
item_6     <- new("item_GR", slope = 0.9, category = c(-1, 0, 1), ncat = 4)
sim_item_6 <- simResp(item_6, seq(-3, 3, 1))
sim_itempool <- simResp(itempool_science, seq(-3, 3, 1))
}
\references{
{
  \insertRef{rasch_probabilistic_1960}{TestDesign}
}

{
  \insertRef{lord_theory_1952}{TestDesign}

  \insertRef{birnbaum_efficient_1957}{TestDesign}

  \insertRef{birnbaum_estimation_1958}{TestDesign}

  \insertRef{birnbaum_further_1958}{TestDesign}
}

{
  \insertRef{birnbaum_latent_1968}{TestDesign}
}

{
  \insertRef{masters_rasch_1982}{TestDesign}

  \insertRef{andrich_rating_1978}{TestDesign}
}

{
  \insertRef{muraki_generalized_1992}{TestDesign}
}

{
  \insertRef{samejima_estimation_1969}{TestDesign}
}
}
