% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SORM.R
\name{SORM}
\alias{SORM}
\title{Reliability Analysis at Biberach University of applied sciences}
\usage{
SORM(lsf, lDistr, debug.level = 0)
}
\arguments{
\item{lsf}{objective function with limit state function in form of function(x) {x[1]+x[2]...}}

\item{lDistr}{list ob distribiutions regarding the distribution object of TesiproV}

\item{debug.level}{If 0 no additional info if 2 high output during calculation}
}
\value{
The results will be provided within a list with the following objects. Acess them with "$"-accessor

beta ... HasoferLind Beta Index

pf ... probablity of failure

u_points ... solution points

dy ... gradients
}
\description{
# S. Marelli, and B. Sudret, UQLab: A framework for uncertainty quantification in Matlab, Proc. 2nd Int. Conf. on Vulnerability, Risk Analysis and Management (ICVRAM2014), Liverpool (United Kingdom), 2014, 2554-2563.
S. Lacaze and S. Missoum, CODES: A Toolbox For Computational Design, Version 1.0, 2015, URL: www.codes.arizona.edu/toolbox.
X. Z. Wu, Implementing statistical fitting and reliability analysis for geotechnical engineering problems in R. Georisk: Assessment and Management of Risk for Engineered Systems and Geohazards, 2017, 11.2: 173-188.
}
\references{
Breitung, K. (1989). Asymptotic approximations for probability integrals. Probabilistic Engineering Mechanics 4(4), 187–190. 9, 10

Cai, G. Q. and I. Elishakoff (1994). Refined second-order reliability analysis. Structural Safety 14(4), 267–276. 9, 10

Hohenbichler, M., S. Gollwitzer, W. Kruse, and R. Rackwitz (1987). New light on first- and second order reliability methods. Structural Safety 4, 267–284. 10

Tvedt, L. (1990). Distribution of quadratic forms in normal space – Applications to structural reliability. Journal of Engineering Mechanics 116(6), 1183–1197. 10
}
\author{
(C) 2021 -  T. Feiri, K. Nille-Hauf, M. Ricker - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
