% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{fit.Exp}
\alias{fit.Exp}
\title{Exponential Distribution Parameter Estimation}
\usage{
fit.Exp(time, status, sig = 0.05, tau = NULL)
}
\arguments{
\item{time}{Numeric observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{sig}{Significance level, for CIs.}

\item{tau}{Optional truncation times for calculating RMSTs.}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated model parameters.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance of the time to event distribution.}
 \item{RMST}{The estimated RMSTs, if tau was specified.}
}
}
\description{
Estimates parameters for exponential event times subject to non-informative
right censoring. The exponential distribution is parameterized in terms
of the rate \eqn{\lambda}: \deqn{f(t) = \lambda e^{-\lambda t}, t>0}
}
\examples{
# Generate exponential data with 20\% censoring
data = genData(n=1e3,dist="exp",theta=c(2),p=0.2);
# Estimate
fit = fitParaSurv(time=data$time,status=data$status,dist="exp");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
