% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{rCTS}
\alias{rCTS}
\title{Function to generate random variates of CTS distribution.}
\usage{
rCTS(
  n,
  alpha = NULL,
  deltap = NULL,
  deltam = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  methodR = "AR",
  k = 10000,
  c = 1
)
}
\arguments{
\item{n}{sample size (integer).}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{deltap}{Scale parameter for the right tail. A real number > 0.}

\item{deltam}{Scale parameter for the left tail. A real number > 0.}

\item{lambdap}{Tempering parameter for the right tail. A real number > 0.}

\item{lambdam}{Tempering parameter for the left tail. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{methodR}{A String. Either "AR" or "SR".}

\item{k}{integer: the level of truncation, if \code{methodR == "SR"}. 10000
by default.}

\item{c}{A real number. Only relevant for \code{methodR == "AR"}.
1 by default.}
}
\value{
Generates \code{n} random numbers.
}
\description{
Generates \code{n} random numbers distributed according to the classic
tempered stable (CTS) distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, deltap, deltam,
lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}.
"AR" stands for the approximate Acceptance-Rejection Method and "SR" for a
truncated infinite shot noise series representation. "AR" is the standard
method used.
For more details, see references.
}
\examples{
rCTS(10,0.5,1,1,1,1,1,NULL,"SR",10)
rCTS(10,0.5,1,1,1,1,1,NULL,"aAR")

}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'

Kawai, R & Masuda, H (2011), 'On simulation of tempered stable random
variates' \doi{10.1016/j.cam.2010.12.014}
}
