% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.TSVC.R
\name{predict.TSVC}
\alias{predict.TSVC}
\title{Prediction from Varying Coefficient Trees}
\usage{
\method{predict}{TSVC}(object, X_new = NULL, ...)
}
\arguments{
\item{object}{a fitted object of class \code{\link[TSVC]{TSVC}}.}

\item{X_new}{optionally, data frame of class \code{\link{data.frame}} which contains the variables with which to predict. If \code{NULL}, the fitted 
linear predictors are use.}

\item{...}{further arguments passed to \code{\link[stats]{predict.glm}}.}
}
\description{
Obtains predictions from a fitted TSVC object.
}
\details{
\code{predict.TSVC} is a wrapper function of \code{predict.glm}, which obtains predictions for objects of class \code{\link[stats]{glm}}. Further
arguments can be passed to \code{predict.glm} via the '...'-argument.
}
\examples{
# Swiss Labour Market 
library(AER)
data("SwissLabor")

# recode factors
sl <- SwissLabor
sl$participation <- as.numeric(sl$participation)-1
sl$foreign       <- as.numeric(sl$foreign)-1

X_new <- data.frame("income"=c(10,12), "age"=c(4.5,5.8))

\dontrun{
fit1 <- TSVC(participation~income+age, data=sl, family=binomial(link="logit"), 
             nperm=1000, trace=TRUE)
predict(fit1, X_new, type="response")
}


}
\references{
Berger, M., G. Tutz and M. Schmid (2019). Tree-Structured Modelling of Varying Coefficients. Statistics and Computing 29, 217-229,
https://doi.org/10.1007/s11222-018-9804-8.
}
\seealso{
\code{\link[TSVC]{TSVC}}, \code{\link[TSVC]{plot.TSVC}}, \code{\link[TSVC]{summary.TSVC}}
}
\author{
Moritz Berger <moritz.berger@imbie.uni-bonn.de> \cr \url{https://www.imbie.uni-bonn.de/people/dr-moritz-berger/}
}
