% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_bp.r
\name{outliers_bp}
\alias{outliers_bp}
\title{Outlier removal from sliding windows of data}
\usage{
outliers_bp(data, alpha = 1.5)
}
\arguments{
\item{data}{A numeric matrix with sliding windows of time series data
as returned by \code{\link{sw}}.}

\item{alpha}{The multiplier for the interquartile range used as base for outlier removal. 
The default is set to \code{1.5}. The value \code{3.0} is also commonly used 
to remove only the extreme outliers.}
}
\value{
Same as \code{data} with outliers removed.
}
\description{
Function to perform outlier removal from sliding windows of data.
The \code{outliers_bp()} function removes windows with extreme values  
using a method based on Box plots for detecting outliers.
}
\details{
The method applied prune any value smaller than the first quartile minus 1.5 times
the interquartile range, and also any value larger than the third quartile plus 1.5
times the interquartile range, that is, all the values that are not in the range
[Q1-1.5xIQR, Q3+1.5xIQR] are considered outliers and are consequently removed.
}
\examples{

data(CATS)
swin <- sw(CATS[,1],5)
d <- outliers_bp(swin)

}
\references{
E. Ogasawara, L. C. Martinez, D. De Oliveira, G. Zimbrao, G. L. Pappa, and M. Mattoso, 2010,
Adaptive Normalization: A novel data normalization approach for non-stationary time series, 
Proceedings of the International Joint Conference on Neural Networks.
}
\seealso{
Other transformation methods: 
\code{\link{Diff}()},
\code{\link{LogT}()},
\code{\link{WaveletT}()},
\code{\link{emd}()},
\code{\link{mas}()},
\code{\link{mlm_io}()},
\code{\link{pct}()},
\code{\link{train_test_subset}()}
}
\author{
Rebecca Pontes Salles
}
\concept{transformation methods}
\keyword{outlier}
\keyword{removal}
\keyword{series}
\keyword{time}
