% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECD.R
\name{ECD}
\alias{ECD}
\title{ECD algorithm for estimating the envelope subspace}
\usage{
ECD(M, U, u, ...)
}
\arguments{
\item{M}{The \eqn{p}-by-\eqn{p} positive definite matrix \eqn{M} in the envelope objective function.}

\item{U}{The \eqn{p}-by-\eqn{p} positive semi-definite matrix \eqn{U} in the envelope objective function.}

\item{u}{An integer between 0 and \eqn{n} representing the envelope dimension.}

\item{...}{Additional user-defined arguments:
\itemize{
  \item{\code{maxiter}: The maximal number of iterations.}
  \item{\code{tol}: The tolerance used to assess convergence. See the ECD algorithm in Cook, R. D., & Zhang, X. (2018).}
}
The default values are: \code{maxiter=500; tol=1e-08}.}
}
\value{
Return the orthogonal basis of the envelope subspace with each column represent the sequential direction. For example, the first column is the most informative direction.
}
\description{
Estimate the envelope subspace with specified dimension based on ECD algorithm proposed by Cook, R. D., & Zhang, X. (2018).
}
\details{
Estimate \code{M}-envelope of \code{span(U)}. The dimension of the envelope is \code{u}.

See \code{\link{FGfun}} for the generic objective function.

The ECD algorithm is similar to 1D algorithm proposed by Cook, R. D., & Zhang, X. (2016). A fast and stable algorithm is used for solving each individual objective function.
}
\examples{
##simulate two matrices M and U with an envelope structure#
data <- MenvU_sim(p = 20, u = 5, wishart = TRUE, n = 200)
M <- data$M
U <- data$U
G <- data$Gamma
Gamma_ECD <- ECD(M, U, u=5)
subspace(Gamma_ECD, G)

}
\references{
Cook, R.D. and Zhang, X., 2018. Fast envelope algorithms. Statistica Sinica, 28(3), pp.1179-1197.
}
