% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REND.R
\name{REND}
\alias{REND}
\title{Functional Evenness, Richness and Divergence of Communities,
Species or Populations}
\usage{
REND(TPDc = NULL, TPDs = NULL)
}
\arguments{
\item{TPDc}{An object of class "TPDcomm", generated with the
\code{\link{TPDc}} function, containing the TPDc of the considered
communities.}

\item{TPDs}{An object of class "TPDsp", generated with the
\code{\link{TPDs}} function, containing the TPDs of the considered
populations or species.}
}
\value{
\code{REND} returns a list with an element for each of the
   provided parameters (ie. communities and/or populations/species). These
   lists contain in turn one element for the Functional Richness  of each
   unit, one for Functional Evenness, and one for Functional Divergence.
}
\description{
\code{REND} computes Functional Richness, Functional Evenness and
   Functional Divergence, the three primary components of functional
   diversity (Mason et al. 2005) for single or multiple traits. Although
   these components were originally intended to be calculated for communities,
   \code{REND} also allows to compute them for populations or species.
   In the case of communities, all the calculations are based on the TPDc of
   the considered communities; therefore results are independent of any
   underlying feature of the species that compose the communities.
}
\examples{
# 1.  Compute the TPDs of five different species. SP3 is in the center of
#   the trait space, and the rest of species in the corners
set.seed(1)
species_ex <- c(rep("SP1",20), rep("SP2",20), rep("SP3",20), rep("SP4",20),
             rep("SP5",20))
traits_ex <- data.frame(trait1 = c(rnorm(20, 10, 1),
                                   rnorm(20, 10, 1),
                                   rnorm(20, 15, 1),
                                   rnorm(20, 20, 1),
                                   rnorm(20, 20, 1)),
                        trait2 = c(rnorm(20, 10, 1),
                                   rnorm(20, 20, 1),
                                   rnorm(20, 15, 1),
                                   rnorm(20, 10, 1),
                                   rnorm(20, 20, 1)))
species_TPDs <- TPDs (species = species_ex, traits = traits_ex)
#2. Five different communities with different abundances of each species
abundances_ex <- matrix(c(0.05, 0.05, 0.8,  0.05, 0.05, # 1. Low divergence
                   0.9,  0,    0,    0,    0.1,  # 2. High divergence
                   0,    0,    1,    0,    0,    # 3. Low Richness
                   0.2,  0.2,  0.2,  0.2,  0.2,  # 4. High Evenness
                   0.8,  0.05, 0.05, 0.05, 0.05), # 5. Low Evenness
                   ncol = 5, byrow = TRUE, dimnames = list(paste0("Comm.",1:5),
                   unique(species_ex)))

example_TPDc <- TPDc (TPDs = species_TPDs, sampUnit = abundances_ex)
#3. Estimate functional richness, evenness and divergence
example_RicEveDiv <- REND (TPDc = example_TPDc)
}
\references{
Mason, NWH, Mouillot, D, Lee, WG and Wilson, JB (2005),
   Functional richness, functional evenness and functional divergence:
   the primary components of functional diversity. \emph{Oikos},
   111: 112--118.
}
