% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPC_pl.R
\name{TPC_pl}
\alias{TPC_pl}
\title{Variable Selection via Thresholded Partial Correlation}
\usage{
TPC_pl(y, x, u = NULL, s = 0.05, constant = 1, method = "threshold", ...)
}
\arguments{
\item{y}{response vector;}

\item{x}{covariate matrix;}

\item{u}{non-parametric variable, should be a vector;}

\item{s}{\code{s} is a numeric value or vector that used as the significance level(s) for the partial correlation tests}

\item{constant}{a value that used as the tuning constant for partial
correlation test. \code{constant} is treated as 1 when method is "simple".}

\item{method}{the method to be used; default set as method = "threshold";
"simple" is also available.}

\item{...}{smoothing parameters and functions: \code{kernel}, \code{degree}, and bandwidth \code{h}.}
}
\value{
TPC.object a TPC object, which extends the \code{lm} object. New attributes are:
\itemize{
\item beta - the fitted coefficients
\item selected_index - the selected coefficients indices
}
}
\description{
These are the main selection functions with fixed significance level \code{s} and \code{constant}.
The function \code{TPC} implements the thresholded partial correlation (TPC) approach to selecting important
variables in linear models of Li et al. (2017).
The function \code{TPC_pl} implements the thresholded partial correlation approach to selecting important
variables in partial linear models of Liu et al. (2018).
This function also extends the PC-simple algorithm of Bühlmann et al. (2010) to partial linear models.
}
\examples{
#generate partial linear data
samples <- generate_toy_pldata()
y <- samples[[1]]
x <- samples[[2]]
times <- samples[[3]]

#perform variable selection via partial correlation
TPC.fit = TPC_pl(y,x,times,0.05,1,method="threshold")
TPC.fit$beta

}
