% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_plot.R
\name{ma_plot}
\alias{ma_plot}
\title{MversusA plot for visualizing differentially expressed genes.}
\usage{
ma_plot(
  data,
  foldchange = 2,
  fdr_value = 0.05,
  point_size = 0.5,
  color_up = "#FF0000",
  color_down = "#008800",
  color_alpha = 0.5,
  top_method = "fc",
  top_num = 20,
  label_size = 8,
  label_box = TRUE,
  title = "Group1 -versus- Group2",
  xlab = "Log2 mean expression",
  ylab = "Log2 fold change",
  ggTheme = "theme_minimal"
)
}
\arguments{
\item{data}{Dataframe: include columns (Genes, baseMean, Log2FoldChange, Padj), rows (Genes).}

\item{foldchange}{Numeric: fold change value. Default: 2.00, min: 0.00, max: null.}

\item{fdr_value}{Numeric: false discovery rate. Default: 0.05, min: 0.00, max: 1.00.}

\item{point_size}{Numeric: point size. Default: 0.50, min: 0.00, max: null.}

\item{color_up}{Character: up-regulated genes color (color name or hex value). Default: "#FF0000".}

\item{color_down}{Character: down-regulated genes color (color name or hex value). Default: "#008800".}

\item{color_alpha}{Numeric: point color alpha. Default: 0.50, min: 0.00, max: 1.00.}

\item{top_method}{Character: top genes select method. Default: "fc" (fold change), options: "padj" (p-adjust), "fc".}

\item{top_num}{Numeric: top genes number. Default: 20, min: 0, max: null.}

\item{label_size}{Numeric: label font size. Default: 8.00, min: 0.00, max: null.}

\item{label_box}{Logical: add box to label. Default: TRUE, options: TRUE, FALSE.}

\item{title}{Character: plot title. Default: "Group1 -versus- Group2".}

\item{xlab}{Character: x label. Default: "Log2 mean expression".}

\item{ylab}{Character: y label. Default: "Log2 fold change".}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_minimal", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void"}
}
\value{
Plot: MversusA plot for visualizing differentially expressed genes.
}
\description{
MversusA plot for visualizing differentially expressed genes.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(deg_data2)

# 3. Default parameters
ma_plot(deg_data2)

# 4. Set color_up = "#FF8800"
ma_plot(deg_data2, color_up = "#FF8800")

# 5. Set color_alpha = 0.30
ma_plot(deg_data2, color_alpha = 0.30)

}
\author{
benben-miao
}
