% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_compare_smd.R
\name{boot_compare_smd}
\alias{boot_compare_smd}
\title{Comparing SMDs between ndependent studies with bootstrapping}
\usage{
boot_compare_smd(
  x1,
  y1 = NULL,
  x2,
  y2 = NULL,
  null = 0,
  paired = FALSE,
  alternative = c("two.sided", "less", "greater"),
  R = 1999,
  alpha = 0.05
)
}
\arguments{
\item{x1}{a (non-empty) numeric vector of data values from study 1.}

\item{y1}{an optional (non-empty) numeric vector of data values from study 1.}

\item{x2}{a (non-empty) numeric vector of data values from study 2.}

\item{y2}{an optional (non-empty) numeric vector of data values from study 2.}

\item{null}{a number indicating the null hypothesis. For TOST, this would be equivalence bound.}

\item{paired}{a logical indicating whether the SMD is from a paired or independent samples design.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{R}{number of bootstrap replicates}

\item{alpha}{alpha level (default = 0.05)}
}
\value{
A list with class "htest" containing the following components:
\itemize{
\item "statistic": z-score.
\item "p.value": numeric scalar containing the p-value for the test under the null hypothesis.
\item "estimate": difference in SMD between studies
\item "conf.int": percentile (bootstrap) confidence interval for difference in SMDs
\item "null.value": the specified hypothesized value for the null hypothesis.
\item "alternative": character string indicating the alternative hypothesis (the value of the input argument alternative). Possible values are "greater", "less", or "two-sided".
\item "method": Type of SMD.
\item "data.name": "Boostrapped" to denote summary statistics were utilized to obtain results.
\item "smd": SMDs input for the function.
\item "df_ci": Data frame of confidence intervals.
\item "boot_res": List of bootstrapped results.
\item "call": the matched call.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function to compare standardized mean differences (SMDs) between studies.
This function is intended to be used to compare the compatibility of original studies with replication studies
(lower p-values indicating lower compatibility).
}
\seealso{
Other compare studies: 
\code{\link{boot_compare_cor}()},
\code{\link{compare_cor}()},
\code{\link{compare_smd}()}
}
\concept{compare studies}
