% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNRS_base.R
\name{.TNRS_base}
\alias{.TNRS_base}
\title{Resolve a single batch of (plant) taxonomic names}
\usage{
.TNRS_base(
  taxonomic_names,
  sources = "tpl,tropicos,usda",
  classification = "tropicos",
  mode = "resolve",
  matches = "best"
)
}
\arguments{
\item{taxonomic_names}{Data.frame containing two columns: 1) Row number, 2) Taxonomic names to be resolved (or parsed).  Alternatively, a character vector of names can be supplied.}

\item{sources}{Character. Taxonomic sources to use. Default is "tpl,tropicos,usda". Options include tpl,tropicos,usda,ncbi}

\item{classification}{Character. Family classification to use. Currently the only options is "tropicos", which is equivalent to APGIII.}

\item{mode}{Character.  Options are "resolve" and "parse". Default option is "resolve"}

\item{matches}{Character. Should all matches be returned ("all") or only the best match ("best", the default)?}
}
\value{
Dataframe containing TNRS results.
}
\description{
Resolve a small batch of plant taxonomic names
}
\note{
This function is primarily used as an internal function of TNRS and can only handle relatively small batches of names.
}
\keyword{Internal}
