% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.nn.R
\name{bw.nn}
\alias{bw.nn}
\title{Nearest neighbor bandwidth calculation}
\usage{
bw.nn(x, prop = 0.2, tol = 1e-06)
}
\arguments{
\item{x}{matrix; dissimilarity matrix between points in a data set}

\item{prop}{proportion of observations that defines neighborhood of a point}

\item{tol}{tolerance for zero bandwidth check}
}
\value{
a vector of bandwidths for each tree (row) in x
}
\description{
This function finds the bandwidth for an ultrametric based on the tropical distance of the nearest point.
The function provides the bandwidth input to trop.KDE and was originally used in the KDETrees package.
}
\examples{
\donttest{
T1<-Sim_Trees15
T2<-Sim_Trees25
D <- rbind(T1, T2[1,])
M <- pw.trop.dist(D, D)
bw.nn(M)
}
}
\references{
Weyenberg, G., Huggins, P., Schardl, C., Howe, D. K., & Yoshida, R. (2014). kdetrees: Nonparametric Estimation of Phylogenetic Tree Distributions. In Bioinformatics.

\url{https://github.com/grady/kdetrees/blob/master/R/bw.R}
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
