% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_extract.TL.R
\name{mod_extract.TL}
\alias{mod_extract.TL}
\title{Extract TL}
\usage{
mod_extract.TL(object, plotting.parameters = list(no.plot = FALSE),
  record.parameters = list(separatePreheat = TRUE, recDuringPreheatRamp =
  FALSE, recDuringPreheatPlateau = FALSE))
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the initial TL curves.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}

\item{record.parameters}{\link{list} (with default): list containing the record parameters. See details.}
}
\value{
This function provides a new \code{\linkS4class{TLum.Analysis}} with only the TL curve. \cr
 It also plots the TL curves using \link{plot_extract.TL}.
}
\description{
This function provides a new \code{\linkS4class{TLum.Analysis}} object containing only the TL curves.
}
\details{
\bold{Plotting parameters} \cr
 The plotting parameters are:  \cr
 \describe{
   \item{\code{no.plot}}{
     \link{logical}: If \code{TRUE}, the results will not be plotted.}
 }

 \bold{Record parameters} \cr
 The record parameters are:  \cr
 \describe{
   \item{\code{includePreheat}}{
     \link{logical}: If \code{TRUE}, the preheat was included in the TL recording. If \code{FALSE}, the preheat was recorded separately.}
   \item{\code{recDuringPreheatRamp}}{
     \link{logical}: Only used when \code{includePreheat} is \code{TRUE}. If \code{TRUE}, the signal was recorded during the preheat ramp.}
     \item{\code{recDuringPreheatPlateau}}{
     \link{logical}: Only used when \code{includePreheat} is \code{TRUE}. If \code{TRUE}, the signal was recorded during the preheat plateau.}
 }
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{plot_extract.TL}
}

