#' Assessment of Agreement using the Total Deviation Index
#'
#' The total deviation index (TDI) is an unscaled statistical measure used to evaluate the deviation between paired quantitative measurements when assessing
#' the extent of agreement between different raters. It describes a boundary such that a large specified proportion of the differences in paired measurements
#' are within the boundary (Lin, 2000). This R package implements some methodologies existing in the literature for TDI estimation and inference in the case
#' of two raters reviewed in Perez-Jaume and Carrasco (2015).
#'
#' @section Functions:
#' \code{\link[TDIagree]{TDI}}
#'
#' @section Methods:
#' \code{\link[TDIagree]{print.tdi}}, \code{\link[TDIagree]{plot.tdi}}
#'
#' @section Datasets:
#' \code{\link[TDIagree]{AMLad}}
#'
#' @references  Lin, L. I. K. (2000). Total deviation index for measuring individual agreement with applications in laboratory performance and bioequivalence. Statistics in Medicine, 19(2):255-270.
"_PACKAGE"
