% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_7.R
\name{show_head}
\alias{show_head}
\title{Return a Subset of an Object}
\usage{
show_head(x, i = 6, j = 6)
}
\arguments{
\item{x}{an object.}

\item{i}{an integer vector of length 1. Maximum number of rows (or elements)
to be shown.}

\item{j}{an integer vector of length 1. Maximum number of columns 
(or inner elements) to be shown.}
}
\value{
an object (subset) of the same class as `x`. NULL is returned if the
header cannot be extracted.
}
\description{
Show the first part of an object (vector, matrix, data frame, or list). For 
two-dimensional objects, the operation returns up to a certain number of 
rows and columns as indicated by the user.
}
\details{
This function is a simple error-compliant version 
of a header function. NULL is returned if a header cannot be computed (e.g., 
if a funciton is passed as object `x`.
}
\examples{
my_x <- data.frame(A=1:5, B=2:6, C=3:7)
show_head(my_x, 2, 2)


}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
