% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSVS.R
\name{CSVS}
\alias{CSVS}
\title{Cause-specific variable selection (CSVS)}
\usage{
CSVS(g, model, discreteSurv = TRUE, package = "nnet")
}
\arguments{
\item{g}{the estimated g, must be fixed to one value}

\item{model}{the model fitted using either \code{nnet} or \code{VGAM}}

\item{discreteSurv}{Boolean variable telling us whether a 'simple'
multinomial regression is looked for or if the goal is a discrete
survival-time model for multiple modes of failure is needed.}

\item{package}{Which package has been used to fit the model, \code{nnet}
or \code{VGAM}?}
}
\description{
This function performs CSVS given a model fitted using the \code{multinom()}
function of the \code{nnet} package or the \code{vglm()} function of the
\code{VGAM} package.
}
\examples{
# data extraction:
data("VAP_data")

# the definition of the full model with three potential predictors:
FULL <- outcome ~ ns(day, df = 4) + gender + type + SOFA
# here the define time as a spline with 3 knots

# we first need to fit the multinomial model:
model_full <- multinom(formula = FULL, data = VAP_data,
                       maxit = 150, trace = FALSE)

G <- 9 # let's suppose g equals to nine

# then we proceed to CSVS
CSVS_nnet <- CSVS(g = G, model = model_full,
                  discreteSurv = TRUE, package = 'nnet')
}
\author{
Rachel Heyard
}
