#' MNIST Images of Digit 3
#' 
#' \code{digit3} contains 2000 images from the famous MNIST dataset of digit 3. 
#' Each element of the list is an image represented as an \eqn{(28\times 28)} 
#' matrix that sums to 1. This normalization is conventional and it does not 
#' hurt its visualization via a basic `image()` function.
#' 
#' @usage data(digit3)
#' 
#' @format a length-\eqn{2000} named list \code{"digit3"} of \eqn{(28\times 28)} matrices.
#' 
#' @examples 
#' ## LOAD THE DATA
#' data(digit3)
#' 
#' ## SHOW A FEW
#' opar <- par(no.readonly=TRUE)
#' par(mfrow=c(2,4), pty="s")
#' for (i in 1:8){
#'   image(digit3[[i]])
#' }
#' par(opar)
#' 
#' @concept data
"digit3"