% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss_barypd.R
\name{gaussbarypd}
\alias{gaussbarypd}
\title{Barycenter of Gaussian Distributions in \eqn{\mathbf{R}^p}}
\usage{
gaussbarypd(means, vars, weights = NULL, ...)
}
\arguments{
\item{means}{an \eqn{(n\times p)} matrix whose rows are mean vectors.}

\item{vars}{a \eqn{(p\times p\times n)} array where each slice is covariance matrix.}

\item{weights}{a weight of each image; if \code{NULL} (default), uniform weight is set. Otherwise, it should be a length-\eqn{n} vector of nonnegative weights.}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion for iterations (default: 1e-8).}
\item{maxiter}{maximum number of iterations (default: 496).}
}}
}
\value{
a named list containing \describe{
\item{mean}{a length-\eqn{p} vector for mean of the estimated barycenter distribution.}
\item{var}{a \eqn{(p\times p)} matrix for variance of the estimated barycenter distribution.}
}
}
\description{
Given a collection of \eqn{n}-dimensional Gaussian distributions \eqn{\mathcal{N}(\mu_i, \Sigma_i^2)}
for \eqn{i=1,\ldots,n}, compute the Wasserstein barycenter of order 2.
For the barycenter computation of variance components, we use a fixed-point
algorithm by \insertCite{AlvarezEsteban;textual}{T4transport}.
}
\examples{
\donttest{
#----------------------------------------------------------------------
#                         Two Gaussians in R^2
#----------------------------------------------------------------------
# GENERATE PARAMETERS
# means
par_mean = rbind(c(-4,0), c(4,0))

# covariances
par_vars = array(0,c(2,2,2))
par_vars[,,1] = cbind(c(4,-2),c(-2,4))
par_vars[,,2] = cbind(c(4,+2),c(+2,4))

# COMPUTE THE BARYCENTER OF EQUAL WEIGHTS
gmean = gaussbarypd(par_mean, par_vars)

# GET COORDINATES FOR DRAWING
pt_type1 = gaussvis2d(par_mean[1,], par_vars[,,1])
pt_type2 = gaussvis2d(par_mean[2,], par_vars[,,2])
pt_gmean = gaussvis2d(gmean$mean, gmean$var)

# VISUALIZE
opar <- par(no.readonly=TRUE)
plot(pt_gmean, lwd=2, col="red", type="l",
     main="Barycenter", xlab="", ylab="", 
     xlim=c(-6,6))
lines(pt_type1)
lines(pt_type2)
par(opar)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=gaussbary1d]{gaussbary1d()}} for univariate case.
}
\concept{gaussian}
