% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{test_claims_object}
\alias{test_claims_object}
\title{Claims Data in List Format}
\format{
A \code{claims} object with 10 components:
\describe{
\item{frequency_vector}{vector; number of claims for each occurrence period, see also \code{claim_frequency()}.}
\item{occurrence_list}{list; claim occurrence times for all claims that occurred in each of the period, see also \code{claim_occurrence()}.}
\item{claim_size_list}{list; claim sizes for all claims that occurred in each of the period, see also \code{claim_size()}.}
\item{notification_list}{list; notification delays for all claims that occurred in each of the period, see also \code{claim_notification()}.}
\item{settlement_list}{list; settlement delays for all claims that occurred in each of the period, see also \code{claim_closure()}.}
\item{no_payments_list}{list; number of partial payments for all claims that occurred in each of the period, see also \code{claim_payment_no()}.}
\item{payment_size_list}{(compound) list; sizes of partial payments (without inflation) for all claims that occurred in each of the period, see also \code{claim_payment_size()}.}
\item{payment_delay_list}{(compound) list; inter partial delays for all claims that occurred in each of the period, see also \code{claim_payment_delay()}.}
\item{payment_time_list}{(compound) list; payment times (on a continuous time scale) for all claims that occurred in each of the period, see also \code{claim_payment_time()}.}
\item{payment_inflated_list}{(compound) list; sizes of partial payments (with inflation) for all claims that occurred in each of the period, see also \code{claim_payment_inflation()}.}
}
}
\usage{
test_claims_object
}
\description{
A list containing a sample output from each of the simulation modules, in
sequential order of the running of the modules. This is the test data
generated when run with seed \code{20200131} at the top of the code.
}
\examples{
test_claims_object$frequency_vector
}
\seealso{
\enumerate{
\item Claim occurrence: \code{\link{claim_frequency}}, \code{\link{claim_occurrence}}
\item Claim size: \code{\link{claim_size}}
\item Claim notification: \code{\link{claim_notification}}
\item Claim closure: \code{\link{claim_closure}}
\item Claim payment count: \code{\link{claim_payment_no}}
\item Claim payment size (without inflation): \code{\link{claim_payment_size}}
\item Claim payment time: \code{\link{claim_payment_delay}}, \code{\link{claim_payment_time}}
\item Claim inflation: \code{\link{claim_payment_inflation}}
}
}
\keyword{datasets}
