% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{claim_output}
\alias{claim_output}
\title{Loss Reserving Output}
\usage{
claim_output(
  frequency_vector,
  payment_time_list,
  payment_size_list,
  aggregate_level = 1,
  incremental = TRUE,
  future = TRUE
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{payment_time_list}{(compound) list of payment times (both the continous
time scale and the discrete period versions work).}

\item{payment_size_list}{(compound) list of payment size pattern (can be
either with or without inflation).}

\item{aggregate_level}{number of periods to be aggregated together; must be
a divisor of the total number of periods under consideration (default 1).}

\item{incremental}{logical; if true returns the incremental payment square,
else returns the cumulative payment square.}

\item{future}{logical; if true shows the full claim triangle (i.e. including
claim payments in future periods), else shows only the past triangle (default
TRUE).}
}
\value{
An array of claims payments.
}
\description{
Outputs the full (or past) square of claim payments by occurrence period and
development period. The upper left triangle represents the past, and the
lower right triangle the unseen future. \cr \cr
Users can modify the aggregate level by providing an \code{aggregate_level}
argument to the function. For example, setting \code{aggregate_level = 4} when
working with calendar \emph{quarters} produces a payment square by occurrence and
development \emph{year}.
}
\details{
\strong{Remark on out-of-bound payment times}: This function includes adjustment
for out-of-bound transaction dates, by forcing payments that were projected
to fall out of the maximum development period to be paid at the exact end of
the maximum development period allowed. For example, if we consider 40
periods of development and a claim incurred in the interval (20, 21] was
projected to have a payment at time 62.498210, then we would treat such a
payment as if it occurred at time 60 for the purpose of tabulation.
}
\examples{
attach(test_claims_object)
# a square of cumulative claims payments by accident and development quarters
CL <- claim_output(frequency_vector, payment_time_list, payment_size_list,
                   aggregate_level = 1, incremental = FALSE)
detach(test_claims_object)
}
