% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_t.R
\name{ICA_t}
\alias{ICA_t}
\title{The function \code{\link[=ICA_t]{ICA_t()}} is to evaluate surrogacy in the single-trial causal-inference framework.}
\usage{
ICA_t(
  df,
  T0S0,
  T1S1,
  T0T0 = 1,
  T1T1 = 1,
  S0S0 = 1,
  S1S1 = 1,
  T0T1 = seq(-1, 1, by = 0.1),
  T0S1 = seq(-1, 1, by = 0.1),
  T1S0 = seq(-1, 1, by = 0.1),
  S0S1 = seq(-1, 1, by = 0.1)
)
}
\arguments{
\item{df}{(numeric) is degree of freedom \eqn{\nu}. The maximum value for \eqn{df} is 342. When \eqn{df} exceeds this threshold, the model behavior aligns with the Individual Causal Association (ICA) under the normal causal model.}

\item{T0S0}{A scalar or vector that specifies the correlation(s) between the surrogate and the true endpoint in the control treatment condition}

\item{T1S1}{A scalar or vector that specifies the correlation(s) between the surrogate and the true endpoint in the control treatment condition}

\item{T0T0}{A scalar that specifies the variance of the true endpoint in the control treatment condition}

\item{T1T1}{A scalar that specifies the variance of the true endpoint in the control treatment condition}

\item{S0S0}{A scalar that specifies the variance of the true endpoint in the control treatment condition}

\item{S1S1}{A scalar that specifies the variance of the true endpoint in the control treatment condition}

\item{T0T1}{A scalar or vector that contains the correlation(s) between the counterfactuals T0 and T1}

\item{T0S1}{A scalar or vector that contains the correlation(s) between the counterfactuals T0 and S1}

\item{T1S0}{A scalar or vector that contains the correlation(s) between the counterfactuals T1 and S0}

\item{S0S1}{A scalar or vector that contains the correlation(s) between the counterfactuals S0 and S1}
}
\value{
\itemize{
\item Total.Num.Matrices: An object of class numeric that contains the total number of matrices that can be formed as based on the user-specified correlations in the function call.
\item Pos.Def: A data.frame that contains the positive definite matrices that can be formed based on the user-specified correlations. These matrices are used to compute the vector of the \eqn{\rho_{\Delta}} values.
\item rho: A scalar or vector that contains the individual causal association \eqn{\rho_{\Delta}}
\item ICA: A scalar or vector that contains the individual causal association \eqn{\rho_{\Delta}^2=ICA}
\item ICA_t: A scalar or vector that contains the individual causal association \eqn{ICA_{t}}
\item Sigmas: A data.frame that contains the \eqn{\sigma_{\Delta T}} and \eqn{\sigma_{\Delta S}}
}
}
\description{
The function \code{\link[=ICA_t]{ICA_t()}} is to evaluate surrogacy in the single-trial causal-inference framework.
}
