% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalyticSurvCont.R
\name{summary.MetaAnalyticSurvCont}
\alias{summary.MetaAnalyticSurvCont}
\title{Provides a summary of the surrogacy measures for an object fitted with the 'MetaAnalyticSurvCont()' function.}
\usage{
\method{summary}{MetaAnalyticSurvCont}(object, ...)
}
\arguments{
\item{object}{An object of class 'MetaAnalyticSurvCont' fitted with the 'MetaAnalyticSurvCont()' function.}

\item{...}{...}
}
\value{
The surrogacy measures with their 95\% confidence intervals.
}
\description{
Provides a summary of the surrogacy measures for an object fitted with the 'MetaAnalyticSurvCont()' function.
}
\examples{
\dontrun{
data("colorectal")
data("prostate")
fit <- MetaAnalyticSurvCont(data = prostate, true = SURVTIME, trueind = SURVIND, surrog = PSA,
trt = TREAT, center = TRIAL, trial = TRIAL, patientid = PATID,
copula = "Hougaard", adjustment = "weighted")
summary(fit)
}
}
