% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copula_utils.R
\name{loglik_copula_scale}
\alias{loglik_copula_scale}
\title{Loglikelihood on the Copula Scale}
\usage{
loglik_copula_scale(
  theta,
  u,
  v,
  d1,
  d2,
  copula_family,
  r = 0L,
  return_sum = TRUE
)
}
\arguments{
\item{theta}{Copula parameter}

\item{u}{A numeric vector. Corresponds to first variable on the copula scale.}

\item{v}{A numeric vector. Corresponds to second variable on the copula
scale.}

\item{d1}{An integer vector. Indicates whether first variable is observed or
right-censored,
\itemize{
\item \code{d1[i] = 1} if \code{u[i]} corresponds to non-censored value
\item \code{d1[i] = 0} if \code{u[i]} corresponds to right-censored value
\item \code{d1[i] = -1} if \code{u[i]} corresponds to left-censored value
}}

\item{d2}{An integer vector. Indicates whether first variable is observed or
right-censored,
\itemize{
\item \code{d2[i] = 1} if \code{v[i]} corresponds to non-censored value
\item \code{d2[i] = 0} if \code{v[i]} corresponds to right-censored value
\item \code{d2[i] = -1} if \code{v[i]} corresponds to left-censored value
}}

\item{copula_family}{Copula family, one of the following:
\itemize{
\item \code{"clayton"}
\item \code{"frank"}
\item \code{"gumbel"}
\item \code{"gaussian"}
}}

\item{r}{rotation parameter. Should be \code{0L}, \code{90L}, \code{180L}, or \code{270L}.

The parameterization of the respective copula families can be found in the
help files of the dedicated functions named \code{copula_loglik_copula_scale()}.}

\item{return_sum}{Return the sum of the individual loglikelihoods? If \code{FALSE},
a vector with the individual loglikelihood contributions is returned.}
}
\value{
Value of the copula loglikelihood evaluated in \code{theta}.
}
\description{
\code{loglik_copula_scale()} computes the loglikelihood on the copula scale for
possibly right-censored data.
}
