% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aim_batting.R
\name{cv.aim.batting}
\alias{cv.aim.batting}
\title{The function for CV in aim.batting}
\usage{
cv.aim.batting(y, x, censor.vec = NULL, trt.vec = NULL, trtref = NULL,
  type, n.boot, des.res = "larger", min.sigp.prcnt = 0.2, mc.iter = 1,
  mincut = 0.1, pre.filter = NULL, filter.method = NULL, k.fold = 5,
  cv.iter = 50, max.iter = 500)
}
\arguments{
\item{y}{data frame containing the response}

\item{x}{data frame containing the predictor}

\item{censor.vec}{data frame giving the censor status (only for TTE data , censor=0,event=1)  - default = NULL}

\item{trt.vec}{data frame giving the censor status (only for TTE data , censor=0,event=1)  - default = NULL}

\item{trtref}{treatment reference indicator: 1=treatment, 0=control}

\item{type}{data type - "c" - continuous , "b" - binary, "s" - time to event  - default = "c"}

\item{n.boot}{number of bootstraps in bootstrapping step.}

\item{des.res}{the desired response. "larger": prefer larger response. "smaller": prefer smaller response}

\item{min.sigp.prcnt}{desired proportion of signature positive group size for a given cutoff.}

\item{mc.iter}{# of iterations for the MC procedure to get a stable "best number of predictors"}

\item{mincut}{the minimum cutting proportion for the binary rule at either end. It typically is between 0 and 0.2. It is the parameter in the functions of AIM package.}

\item{pre.filter}{NULL, no prefiltering conducted;"opt", optimized number of predictors selected; An integer: min(opt, integer) of predictors selected}

\item{filter.method}{NULL, no prefiltering, "univariate", univaraite filtering; "glmnet", glmnet filtering}

\item{k.fold}{# cross-validation folds}

\item{cv.iter}{Algotithm terminates after cv.iter successful iterations of cross-validation}

\item{max.iter}{total # iterations (including unsuccessful) allowed.}
}
\value{
"cv.aim.batting" returns a list with following entries: 
\item{stats.summary}{Summary of performance statistics.}
\item{pred.classes}{Data frame containing the predictive clases (TRUE/FALSE) for each iteration.}
\item{folds}{Data frame containing the fold indices (index of the fold for each row) for each iteration.}
\item{sig.list}{List of length cv.iter * k.fold containing the signature generated at each of the  k folds, for all iterations.}
\item{error.log}{List of any error messages that are returned at an iteration.}
\item{interplot}{Treatment*subgroup interaction plot for predictive case}
}
\description{
Implements k-fold cross validation for aim.batting.
}
