% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MCMCSIM}
\alias{MCMCSIM}
\title{Performs MCMC and returns needed values for dose-finding in a list.}
\usage{
MCMCSIM(Y, I, Doses, Groups, T1, Target, Upper, Dose, meanmu, meanslope,
  MeanInts, MeanSlopes, varint, varbeta, phetero, Stopped, NumPat, SubRout,
  B)
}
\arguments{
\item{Y}{Vector containing observed event or censoring times.}

\item{I}{Vector containing event indicators (1 if patient experiences an event for a patient).}

\item{Doses}{Vector containing Doses of patients in trial.}

\item{Groups}{Vector containing group assignment of patients, 0 is baseline group.}

\item{T1}{Reference time for toxicity.}

\item{Target}{Target cumulative toxicity probability vector at time T1.}

\item{Upper}{Cutoff values used to determine if accrual in a subgroup should be suspended.}

\item{Dose}{Vector containing the standardized doses considered.}

\item{meanmu}{Prior mean for baseline intercept.}

\item{meanslope}{Prior mean for baseline slope.}

\item{MeanInts}{Vector of prior means for the group specific intercept parameters.}

\item{MeanSlopes}{Vector of prior means for the group specific slope parameters.}

\item{varint}{Prior variance for the intercept parameters.}

\item{varbeta}{Prior variance for the slope parameters.}

\item{phetero}{Prior probability of heterogeneous subgroups.}

\item{Stopped}{Current vector of STOPPED groups}

\item{NumPat}{Number of patients}

\item{SubRout}{Parameter to specify subgroup borrowing/clustering. 0=No borrowing, 1=Borrowing but no clustering, 2=Borrowing and clustering.}

\item{B}{Number of Iterations to run for MCMC}
}
\value{
A matrix of quantities needed for determining the next dose to enroll each subgroup while using the SimTrial function.
}
\description{
Performs MCMC and returns needed values for dose-finding in a list.
}
