# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

LikeStoppedCluster <- function(Y, I, Dose, Group, mu, slope, a, b, T1, nPats, GroupMem1, Stopped) {
    .Call('_SubTite_LikeStoppedCluster', PACKAGE = 'SubTite', Y, I, Dose, Group, mu, slope, a, b, T1, nPats, GroupMem1, Stopped)
}

LikeStoppedSeparate <- function(Y, I, Dose, Group, a, b, T1, nPats, Stopped) {
    .Call('_SubTite_LikeStoppedSeparate', PACKAGE = 'SubTite', Y, I, Dose, Group, a, b, T1, nPats, Stopped)
}

GetRandGroup <- function(INC, Stopped) {
    .Call('_SubTite_GetRandGroup', PACKAGE = 'SubTite', INC, Stopped)
}

#' Performs MCMC and returns needed values for dose-finding in a list.
#' @param Y Vector containing observed event or censoring times.
#' @param I Vector containing event indicators (1 if patient experiences an event for a patient).
#' @param Doses Vector containing Doses of patients in trial.
#' @param Groups Vector containing group assignment of patients, 0 is baseline group.
#' @param T1 Reference time for toxicity.
#' @param Target Target cumulative toxicity probability vector at time T1.
#' @param Dose Vector containing the standardized doses considered.
#' @param Upper Cutoff values used to determine if accrual in a subgroup should be suspended.
#' @param meanmu Prior mean for baseline intercept.
#' @param meanslope Prior mean for baseline slope.
#' @param MeanInts Vector of prior means for the group specific intercept parameters.
#' @param MeanSlopes Vector of prior means for the group specific slope parameters.
#' @param varint Prior variance for the intercept parameters.
#' @param varbeta Prior variance for the slope parameters.
#' @param phetero Prior probability of heterogeneous subgroups.
#' @param SubRout Parameter to specify subgroup borrowing/clustering. 0=No borrowing, 1=Borrowing but no clustering, 2=Borrowing and clustering.
#' @param B Number of Iterations to run for MCMC
#' @param Stopped Current vector of STOPPED groups
#' @param NumPat Number of patients
#'@importFrom Rcpp evalCpp
#'@useDynLib SubTite
#'@return A list of quantities needed for determining the next dose to enroll each subgroup.
#'@export
MCMC <- function(Y, I, Doses, Groups, T1, Target, Upper, Dose, meanmu, meanslope, MeanInts, MeanSlopes, varint, varbeta, phetero, Stopped, NumPat, SubRout, B) {
    .Call('_SubTite_MCMC', PACKAGE = 'SubTite', Y, I, Doses, Groups, T1, Target, Upper, Dose, meanmu, meanslope, MeanInts, MeanSlopes, varint, varbeta, phetero, Stopped, NumPat, SubRout, B)
}

#' Performs MCMC and returns needed values for dose-finding in a list.
#' @param Y Vector containing observed event or censoring times.
#' @param I Vector containing event indicators (1 if patient experiences an event for a patient).
#' @param Doses Vector containing Doses of patients in trial.
#' @param Groups Vector containing group assignment of patients, 0 is baseline group.
#' @param T1 Reference time for toxicity.
#' @param Target Target cumulative toxicity probability vector at time T1.
#' @param Dose Vector containing the standardized doses considered.
#' @param Upper Cutoff values used to determine if accrual in a subgroup should be suspended.
#' @param meanmu Prior mean for baseline intercept.
#' @param meanslope Prior mean for baseline slope.
#' @param MeanInts Vector of prior means for the group specific intercept parameters.
#' @param MeanSlopes Vector of prior means for the group specific slope parameters.
#' @param varint Prior variance for the intercept parameters.
#' @param varbeta Prior variance for the slope parameters.
#' @param phetero Prior probability of heterogeneous subgroups.
#' @param SubRout Parameter to specify subgroup borrowing/clustering. 0=No borrowing, 1=Borrowing but no clustering, 2=Borrowing and clustering.
#' @param B Number of Iterations to run for MCMC
#' @param Stopped Current vector of STOPPED groups
#' @param NumPat Number of patients
#'@importFrom Rcpp evalCpp
#'@useDynLib SubTite
#'@return A matrix of quantities needed for determining the next dose to enroll each subgroup while using the SimTrial function.
#'@export
MCMCSIM <- function(Y, I, Doses, Groups, T1, Target, Upper, Dose, meanmu, meanslope, MeanInts, MeanSlopes, varint, varbeta, phetero, Stopped, NumPat, SubRout, B) {
    .Call('_SubTite_MCMCSIM', PACKAGE = 'SubTite', Y, I, Doses, Groups, T1, Target, Upper, Dose, meanmu, meanslope, MeanInts, MeanSlopes, varint, varbeta, phetero, Stopped, NumPat, SubRout, B)
}

#' Simulates a Sub-TITE trial design
#'
#' Simulates replicates from a Sub-TITE trial with user specified true toxicity time distributions for different doses and subgroups and returns average summary statistics of the trial.
#' @param nSims Number of Trials to Simulate.
#' @param Nmax Maximum Number of Patients to enroll in the trial.
#' @param T1 Reference time for toxicity.
#' @param Target Target cumulative toxicity probability (or subgroup specific vector) at time T1.
#' @param Dose Standardized vector of doses to try.
#' @param DoseStart Dose (or vector of Doses) to enroll the first patient in each subgroup at.
#' @param Accrue Expected montly patient accrual rate.
#' @param groupprob Probability vector of subgroup assignment.
#' @param Upper Cutoff values used to determine if accrual in a subgroup should be suspended.
#' @param meanmu Prior mean of the baseline intercept parameter.
#' @param meanslope Prior mean of the baseline slope parameter.
#' @param MeanInts G-1 length vector of subgroup specific prior intercept means.
#' @param MeanSlopes G-1 length vector of subgroup specific prior slope means.
#' @param Family What distribution Family to simulate from. Options include: Exponential,Gamma, Lognormal, Uniform, Weibull.
#' @param Param1 nGroups X nDose matrix of first parameter values.
#' @param Param2 NGroups X nDose matrix of second parameter values.
#' @param varint Prior Variance of Intercept Parameters.
#' @param varbeta Prior Variance of Slope Parameters.
#' @param phetero Prior prob of heterogeneity.
#' @param NSep Number of patients to assign based on no borrowing.
#' @param NBorrow Number of patients to assign based on no clustering
#' @param cohort Number of patients to enroll before escalating.
#' @param FULLY Do we have to fully evaluate a cohort before escalating?
#' @return A list of simulation outputs to be processed in R.
SimTrial1 <- function(nSims, Nmax, T1, Target, Dose, DoseStart, Upper, Accrue, groupprob, Family, Param1, Param2, meanmu, meanslope, MeanInts, MeanSlopes, varint, varbeta, phetero, NSep, NBorrow, cohort, FULLY) {
    .Call('_SubTite_SimTrial1', PACKAGE = 'SubTite', nSims, Nmax, T1, Target, Dose, DoseStart, Upper, Accrue, groupprob, Family, Param1, Param2, meanmu, meanslope, MeanInts, MeanSlopes, varint, varbeta, phetero, NSep, NBorrow, cohort, FULLY)
}

