% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_glmnet.R
\name{ple_glmnet}
\alias{ple_glmnet}
\title{Patient-level Estimates: Elastic Net (glmnet)}
\usage{
ple_glmnet(Y, A, X, Xtest, lambda = "lambda.min", family, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{Xtest}{Test set}

\item{lambda}{Lambda for elastic-net (default = "lambda.min"). Other options include
"lambda.1se" or  fixed values}

\item{family}{Outcome type ("gaussian", "binomial", "survival"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Patient-level estimates (E(Y|X,1), E(Y|X,0), E(Y|X,1)-E(Y|X,0)) or
 (HR(X,1), HR(X,0), HR(X,1)-HR(X,0)) for train/test sets.
 \itemize{
  \item mods - trained model(s)
  \item mu_train - Patient-level estimates (training set)
  \item mu_test - Patient-level estimates (test set)
}
}
\description{
Uses the elastic net (glmnet R package) to obtain patient-level estimates.
For continuous/binary, output estimates of E(Y|X,A=a) and E(Y|X,A=1)-E(Y|X,A=0) (PLE).
For survival, output estimates of HR(X,A=a) and HR(X, A=1)-HR(X, A=0) (PLE).
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

mod1 = ple_glmnet(Y, A, X, Xtest=X, family="gaussian")
summary(mod1$mu_train$PLE)


}
\seealso{
\code{\link{PRISM}}, \code{\link{glmnet}}
}
