% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ks.R
\name{ks}
\alias{ks}
\title{Kolmogorov-Smirnov statistic for predicted binary response}
\usage{
ks(y, yhat)
}
\arguments{
\item{y}{actual binary response}

\item{yhat}{predicted probabilities corresponding to the actual binary response}
}
\value{
a two element list: table for KS computation and KS value itself
}
\description{
Takes in actual binary response and predicted probabilities, and returns table
 used for KS computation and KS value
}
\details{
Kolmogorov-Smirnov statistic can be easily computed using \code{ks} function. It
 not only computes the statistic but also returns the table used for ks computation.
 A chart is also plotted for quick visualization of split between percentage of
 responders and non-responders. Deciles are used for computation.

 Appropriate elements of the 2 element list (ie. ksTable or ks) can be picked
 using the code given in the example.
}
\examples{
# A 'data.frame' with y and yhat
df <- data.frame(y = c(1, 0, 1, 1, 0),
                 yhat = c(0.86, 0.23, 0.65, 0.92, 0.37))

# KS table and value
ltKs <- ks(y = df[, 'y'], yhat = df[, 'yhat'])
ksTable <- ltKs$ksTable
KS <- ltKs$ks
}
\author{
Akash Jain
}
\seealso{
\code{\link{accuracy}}, \code{\link{auc}}, \code{\link{iv}}, \code{\link{splitdata}}
}

