// Generated by rstantools.  Do not edit by hand.

/*
    StanMoMo is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    StanMoMo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with StanMoMo.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_leecarter_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 20, column 2 to column 38)",
                                                      " (in 'string', line 21, column 2 to column 14)",
                                                      " (in 'string', line 22, column 2 to column 15)",
                                                      " (in 'string', line 23, column 2 to column 9)",
                                                      " (in 'string', line 24, column 2 to column 17)",
                                                      " (in 'string', line 25, column 2 to column 24)",
                                                      " (in 'string', line 28, column 2 to column 14)",
                                                      " (in 'string', line 29, column 2 to column 33)",
                                                      " (in 'string', line 30, column 2 to column 11)",
                                                      " (in 'string', line 31, column 2 to column 12)",
                                                      " (in 'string', line 32, column 18 to column 36)",
                                                      " (in 'string', line 32, column 2 to column 36)",
                                                      " (in 'string', line 57, column 2 to column 19)",
                                                      " (in 'string', line 58, column 2 to column 18)",
                                                      " (in 'string', line 59, column 2 to column 22)",
                                                      " (in 'string', line 60, column 2 to column 26)",
                                                      " (in 'string', line 61, column 2 to column 14)",
                                                      " (in 'string', line 62, column 2 to column 14)",
                                                      " (in 'string', line 63, column 2 to column 14)",
                                                      " (in 'string', line 64, column 2 to column 42)",
                                                      " (in 'string', line 65, column 20 to column 68)",
                                                      " (in 'string', line 65, column 2 to column 68)",
                                                      " (in 'string', line 87, column 9 to column 67)",
                                                      " (in 'string', line 88, column 4 to column 13)",
                                                      " (in 'string', line 86, column 13 to line 89, column 11)",
                                                      " (in 'string', line 84, column 9 to column 24)",
                                                      " (in 'string', line 85, column 4 to column 13)",
                                                      " (in 'string', line 83, column 43 to line 86, column 7)",
                                                      " (in 'string', line 83, column 6 to line 89, column 11)",
                                                      " (in 'string', line 82, column 37 to line 90, column 3)",
                                                      " (in 'string', line 82, column 22 to line 90, column 3)",
                                                      " (in 'string', line 82, column 4 to line 90, column 3)",
                                                      " (in 'string', line 92, column 5 to column 100)",
                                                      " (in 'string', line 93, column 5 to column 15)",
                                                      " (in 'string', line 91, column 32 to line 94, column 1)",
                                                      " (in 'string', line 91, column 17 to line 94, column 1)",
                                                      " (in 'string', line 91, column 2 to line 94, column 1)",
                                                      " (in 'string', line 96, column 5 to column 101)",
                                                      " (in 'string', line 97, column 5 to column 15)",
                                                      " (in 'string', line 95, column 34 to line 98, column 1)",
                                                      " (in 'string', line 95, column 19 to line 98, column 1)",
                                                      " (in 'string', line 95, column 1 to line 98, column 1)",
                                                      " (in 'string', line 81, column 22 to line 99, column 3)",
                                                      " (in 'string', line 81, column 7 to line 99, column 3)",
                                                      " (in 'string', line 68, column 4 to column 38)",
                                                      " (in 'string', line 69, column 4 to column 13)",
                                                      " (in 'string', line 67, column 37 to line 70, column 3)",
                                                      " (in 'string', line 67, column 22 to line 70, column 3)",
                                                      " (in 'string', line 67, column 4 to line 70, column 3)",
                                                      " (in 'string', line 71, column 2 to column 21)",
                                                      " (in 'string', line 73, column 4 to column 88)",
                                                      " (in 'string', line 74, column 5 to column 15)",
                                                      " (in 'string', line 72, column 32 to line 75, column 1)",
                                                      " (in 'string', line 72, column 17 to line 75, column 1)",
                                                      " (in 'string', line 72, column 2 to line 75, column 1)",
                                                      " (in 'string', line 77, column 4 to column 88)",
                                                      " (in 'string', line 78, column 5 to column 15)",
                                                      " (in 'string', line 76, column 34 to line 79, column 1)",
                                                      " (in 'string', line 76, column 19 to line 79, column 1)",
                                                      " (in 'string', line 76, column 1 to line 79, column 1)",
                                                      " (in 'string', line 66, column 16 to line 80, column 3)",
                                                      " (in 'string', line 66, column 2 to line 99, column 3)",
                                                      " (in 'string', line 35, column 9 to column 14)",
                                                      " (in 'string', line 35, column 2 to column 19)",
                                                      " (in 'string', line 36, column 2 to column 14)",
                                                      " (in 'string', line 38, column 4 to column 52)",
                                                      " (in 'string', line 39, column 4 to column 13)",
                                                      " (in 'string', line 37, column 32 to line 40, column 3)",
                                                      " (in 'string', line 37, column 17 to line 40, column 3)",
                                                      " (in 'string', line 37, column 2 to line 40, column 3)",
                                                      " (in 'string', line 41, column 2 to column 39)",
                                                      " (in 'string', line 42, column 2 to column 58)",
                                                      " (in 'string', line 48, column 4 to column 48)",
                                                      " (in 'string', line 47, column 7 to line 49, column 3)",
                                                      " (in 'string', line 45, column 4 to column 38)",
                                                      " (in 'string', line 44, column 17 to line 46, column 3)",
                                                      " (in 'string', line 44, column 2 to line 49, column 3)",
                                                      " (in 'string', line 50, column 2 to column 32)",
                                                      " (in 'string', line 51, column 2 to column 38)",
                                                      " (in 'string', line 52, column 2 to column 47)",
                                                      " (in 'string', line 53, column 2 to column 42)",
                                                      " (in 'string', line 54, column 18 to column 72)",
                                                      " (in 'string', line 54, column 2 to column 72)",
                                                      " (in 'string', line 3, column 2 to column 19)",
                                                      " (in 'string', line 4, column 2 to column 19)",
                                                      " (in 'string', line 5, column 8 to column 11)",
                                                      " (in 'string', line 5, column 2 to column 19)",
                                                      " (in 'string', line 6, column 9 to column 13)",
                                                      " (in 'string', line 6, column 2 to column 17)",
                                                      " (in 'string', line 7, column 2 to column 22)",
                                                      " (in 'string', line 8, column 2 to column 22)",
                                                      " (in 'string', line 9, column 8 to column 14)",
                                                      " (in 'string', line 9, column 2 to column 25)",
                                                      " (in 'string', line 10, column 9 to column 16)",
                                                      " (in 'string', line 10, column 2 to column 23)",
                                                      " (in 'string', line 11, column 2 to column 30)",
                                                      " (in 'string', line 14, column 9 to column 14)",
                                                      " (in 'string', line 14, column 2 to column 38)",
                                                      " (in 'string', line 15, column 9 to column 17)",
                                                      " (in 'string', line 15, column 2 to column 39)",
                                                      " (in 'string', line 16, column 2 to column 19)",
                                                      " (in 'string', line 17, column 2 to column 11)",
                                                      " (in 'string', line 20, column 8 to column 18)",
                                                      " (in 'string', line 21, column 9 to column 10)",
                                                      " (in 'string', line 22, column 10 to column 11)",
                                                      " (in 'string', line 24, column 9 to column 12)",
                                                      " (in 'string', line 28, column 9 to column 10)",
                                                      " (in 'string', line 57, column 9 to column 13)",
                                                      " (in 'string', line 58, column 9 to column 10)",
                                                      " (in 'string', line 59, column 9 to column 12)",
                                                      " (in 'string', line 60, column 9 to column 15)"};
#include <stan_meta_header.hpp>
class model_leecarter final : public model_base_crtp<model_leecarter> {
private:
  int J;
  int T;
  std::vector<int> d;
  Eigen::Matrix<double, -1, 1> e;
  int Tfor;
  int Tval;
  std::vector<int> dval;
  Eigen::Matrix<double, -1, 1> eval;
  int family;
  Eigen::Matrix<double, -1, 1> input_offset;
  Eigen::Matrix<double, -1, 1> offset2;
  int L;
  int aux_1dim__;
  int ks_1dim__;
  int log_lik_1dim__;
  int log_lik2_1dim__;
 
public:
  ~model_leecarter() { }
  
  inline std::string model_name() const final { return "model_leecarter"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_leecarter(stan::io::var_context& context__,
                  unsigned int random_seed__ = 0,
                  std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_leecarter_namespace::model_leecarter";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 84;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 84;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 84;
      current_statement__ = 84;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 85;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 85;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 85;
      current_statement__ = 85;
      check_greater_or_equal(function__, "T", T, 1);
      current_statement__ = 86;
      validate_non_negative_index("d", "J * T", (J * T));
      current_statement__ = 87;
      context__.validate_dims("data initialization","d","int",
          context__.to_vec((J * T)));
      d = std::vector<int>((J * T), std::numeric_limits<int>::min());
      
      current_statement__ = 87;
      assign(d, nil_index_list(), context__.vals_i("d"),
        "assigning variable d");
      current_statement__ = 88;
      validate_non_negative_index("e", "J * T", (J * T));
      current_statement__ = 89;
      context__.validate_dims("data initialization","e","double",
          context__.to_vec((J * T)));
      e = Eigen::Matrix<double, -1, 1>((J * T));
      stan::math::fill(e, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> e_flat__;
        current_statement__ = 89;
        assign(e_flat__, nil_index_list(), context__.vals_r("e"),
          "assigning variable e_flat__");
        current_statement__ = 89;
        pos__ = 1;
        current_statement__ = 89;
        for (int sym1__ = 1; sym1__ <= (J * T); ++sym1__) {
          current_statement__ = 89;
          assign(e, cons_list(index_uni(sym1__), nil_index_list()),
            e_flat__[(pos__ - 1)], "assigning variable e");
          current_statement__ = 89;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 90;
      context__.validate_dims("data initialization","Tfor","int",
          context__.to_vec());
      Tfor = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      Tfor = context__.vals_i("Tfor")[(1 - 1)];
      current_statement__ = 90;
      current_statement__ = 90;
      check_greater_or_equal(function__, "Tfor", Tfor, 1);
      current_statement__ = 91;
      context__.validate_dims("data initialization","Tval","int",
          context__.to_vec());
      Tval = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      Tval = context__.vals_i("Tval")[(1 - 1)];
      current_statement__ = 91;
      current_statement__ = 91;
      check_greater_or_equal(function__, "Tval", Tval, 0);
      current_statement__ = 92;
      validate_non_negative_index("dval", "J * Tval", (J * Tval));
      current_statement__ = 93;
      context__.validate_dims("data initialization","dval","int",
          context__.to_vec((J * Tval)));
      dval = std::vector<int>((J * Tval), std::numeric_limits<int>::min());
      
      current_statement__ = 93;
      assign(dval, nil_index_list(), context__.vals_i("dval"),
        "assigning variable dval");
      current_statement__ = 94;
      validate_non_negative_index("eval", "J * Tval", (J * Tval));
      current_statement__ = 95;
      context__.validate_dims("data initialization","eval","double",
          context__.to_vec((J * Tval)));
      eval = Eigen::Matrix<double, -1, 1>((J * Tval));
      stan::math::fill(eval, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eval_flat__;
        current_statement__ = 95;
        assign(eval_flat__, nil_index_list(), context__.vals_r("eval"),
          "assigning variable eval_flat__");
        current_statement__ = 95;
        pos__ = 1;
        current_statement__ = 95;
        for (int sym1__ = 1; sym1__ <= (J * Tval); ++sym1__) {
          current_statement__ = 95;
          assign(eval, cons_list(index_uni(sym1__), nil_index_list()),
            eval_flat__[(pos__ - 1)], "assigning variable eval");
          current_statement__ = 95;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 96;
      context__.validate_dims("data initialization","family","int",
          context__.to_vec());
      family = std::numeric_limits<int>::min();
      
      current_statement__ = 96;
      family = context__.vals_i("family")[(1 - 1)];
      current_statement__ = 96;
      current_statement__ = 96;
      check_greater_or_equal(function__, "family", family, 0);
      current_statement__ = 96;
      current_statement__ = 96;
      check_less_or_equal(function__, "family", family, 1);
      current_statement__ = 97;
      validate_non_negative_index("input_offset", "J * T", (J * T));
      current_statement__ = 98;
      input_offset = Eigen::Matrix<double, -1, 1>((J * T));
      stan::math::fill(input_offset, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 98;
      assign(input_offset, nil_index_list(), stan::math::log(e),
        "assigning variable input_offset");
      current_statement__ = 99;
      validate_non_negative_index("offset2", "J * Tval", (J * Tval));
      current_statement__ = 100;
      offset2 = Eigen::Matrix<double, -1, 1>((J * Tval));
      stan::math::fill(offset2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 100;
      assign(offset2, nil_index_list(), stan::math::log(eval),
        "assigning variable offset2");
      current_statement__ = 101;
      L = std::numeric_limits<int>::min();
      
      current_statement__ = 102;
      L = (J * Tfor);
      current_statement__ = 101;
      current_statement__ = 101;
      check_greater_or_equal(function__, "L", L, 1);
      current_statement__ = 103;
      aux_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 103;
      aux_1dim__ = logical_gt(family, 0);
      current_statement__ = 103;
      validate_non_negative_index("aux", "family > 0", aux_1dim__);
      current_statement__ = 104;
      validate_non_negative_index("a", "J", J);
      current_statement__ = 105;
      validate_positive_index("b", "J", J);
      current_statement__ = 106;
      ks_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 106;
      ks_1dim__ = (T - 1);
      current_statement__ = 106;
      validate_non_negative_index("ks", "T - 1", ks_1dim__);
      current_statement__ = 107;
      validate_non_negative_index("k", "T", T);
      current_statement__ = 108;
      validate_non_negative_index("k_p", "Tfor", Tfor);
      current_statement__ = 109;
      validate_non_negative_index("mufor", "L", L);
      current_statement__ = 110;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 110;
      log_lik_1dim__ = (J * T);
      current_statement__ = 110;
      validate_non_negative_index("log_lik", "J * T", log_lik_1dim__);
      current_statement__ = 111;
      log_lik2_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 111;
      log_lik2_1dim__ = (J * Tval);
      current_statement__ = 111;
      validate_non_negative_index("log_lik2", "J * Tval", log_lik2_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += aux_1dim__;
      num_params_r__ += J;
      num_params_r__ += (J - 1);
      num_params_r__ += 1;
      num_params_r__ += ks_1dim__;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_leecarter_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<local_scalar_t__> aux;
      aux = std::vector<local_scalar_t__>(aux_1dim__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable aux");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(aux[(sym1__ - 1)], 0, lp__),
            "assigning variable aux");
        } else {
          current_statement__ = 1;
          assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(aux[(sym1__ - 1)], 0),
            "assigning variable aux");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> a;
      a = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
      stan::math::fill(a, DUMMY_VAR__);
      
      current_statement__ = 2;
      a = in__.vector(J);
      Eigen::Matrix<local_scalar_t__, -1, 1> b;
      b = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
      stan::math::fill(b, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> b_in__;
      b_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((J - 1));
      stan::math::fill(b_in__, DUMMY_VAR__);
      
      current_statement__ = 3;
      b_in__ = in__.vector((J - 1));
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        assign(b, nil_index_list(),
          stan::math::simplex_constrain(b_in__, lp__), "assigning variable b");
      } else {
        current_statement__ = 3;
        assign(b, nil_index_list(), stan::math::simplex_constrain(b_in__),
          "assigning variable b");
      }
      local_scalar_t__ c;
      c = DUMMY_VAR__;
      
      current_statement__ = 4;
      c = in__.scalar();
      Eigen::Matrix<local_scalar_t__, -1, 1> ks;
      ks = Eigen::Matrix<local_scalar_t__, -1, 1>(ks_1dim__);
      stan::math::fill(ks, DUMMY_VAR__);
      
      current_statement__ = 5;
      ks = in__.vector(ks_1dim__);
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 6;
      sigma = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 6;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> k;
      k = Eigen::Matrix<local_scalar_t__, -1, 1>(T);
      stan::math::fill(k, DUMMY_VAR__);
      
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 8;
      phi = stan::math::negative_infinity();
      current_statement__ = 9;
      assign(k, cons_list(index_uni(1), nil_index_list()), 0,
        "assigning variable k");
      current_statement__ = 10;
      assign(k, cons_list(index_min_max(2, T), nil_index_list()), ks,
        "assigning variable k");
      current_statement__ = 12;
      if (logical_gt(family, 0)) {
        current_statement__ = 11;
        phi = inv(aux[(1 - 1)]);
      } 
      {
        current_statement__ = 63;
        validate_non_negative_index("mu", "J * T", (J * T));
        Eigen::Matrix<local_scalar_t__, -1, 1> mu;
        mu = Eigen::Matrix<local_scalar_t__, -1, 1>((J * T));
        stan::math::fill(mu, DUMMY_VAR__);
        
        int pos;
        pos = std::numeric_limits<int>::min();
        
        current_statement__ = 65;
        pos = 1;
        current_statement__ = 70;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 69;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 66;
            assign(mu, cons_list(index_uni(pos), nil_index_list()),
              ((input_offset[(pos - 1)] + a[(x - 1)]) +
                (b[(x - 1)] * k[(t - 1)])), "assigning variable mu");
            current_statement__ = 67;
            pos = (pos + 1);}}
        current_statement__ = 71;
        lp_accum__.add(normal_lpdf<false>(ks[(1 - 1)], c, sigma));
        current_statement__ = 72;
        lp_accum__.add(
          normal_lpdf<false>(
            rvalue(ks,
              cons_list(index_min_max(2, (T - 1)), nil_index_list()), "ks"),
            add(c,
              rvalue(ks,
                cons_list(index_min_max(1, (T - 2)), nil_index_list()), "ks")),
            sigma));
        current_statement__ = 77;
        if (logical_eq(family, 0)) {
          current_statement__ = 75;
          lp_accum__.add(poisson_log_lpmf<false>(d, mu));
        } else {
          current_statement__ = 73;
          lp_accum__.add(neg_binomial_2_log_lpmf<false>(d, mu, phi));
        }
        current_statement__ = 78;
        lp_accum__.add(normal_lpdf<false>(a, 0, 10));
        current_statement__ = 79;
        lp_accum__.add(normal_lpdf<false>(c, 0, stan::math::sqrt(10)));
        current_statement__ = 80;
        lp_accum__.add(dirichlet_lpdf<false>(b, rep_vector(1, J)));
        current_statement__ = 81;
        lp_accum__.add(exponential_lpdf<false>(sigma, 0.1));
        current_statement__ = 83;
        if (logical_gt(family, 0)) {
          current_statement__ = 82;
          lp_accum__.add(
            (normal_lpdf<false>(aux, 0, 1) - normal_lcdf(0, 0, 1)));
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_leecarter_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<double> aux;
      aux = std::vector<double>(aux_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable aux");}
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(aux[(sym1__ - 1)], 0),
          "assigning variable aux");}
      Eigen::Matrix<double, -1, 1> a;
      a = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      a = in__.vector(J);
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> b_in__;
      b_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((J - 1));
      stan::math::fill(b_in__, DUMMY_VAR__);
      
      current_statement__ = 3;
      b_in__ = in__.vector((J - 1));
      current_statement__ = 3;
      assign(b, nil_index_list(), stan::math::simplex_constrain(b_in__),
        "assigning variable b");
      double c;
      c = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      c = in__.scalar();
      Eigen::Matrix<double, -1, 1> ks;
      ks = Eigen::Matrix<double, -1, 1>(ks_1dim__);
      stan::math::fill(ks, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      ks = in__.vector(ks_1dim__);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma = in__.scalar();
      current_statement__ = 6;
      sigma = stan::math::lb_constrain(sigma, 0);
      Eigen::Matrix<double, -1, 1> k;
      k = Eigen::Matrix<double, -1, 1>(T);
      stan::math::fill(k, std::numeric_limits<double>::quiet_NaN());
      
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        vars__.emplace_back(aux[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(a[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(b[(sym1__ - 1)]);}
      vars__.emplace_back(c);
      for (int sym1__ = 1; sym1__ <= ks_1dim__; ++sym1__) {
        vars__.emplace_back(ks[(sym1__ - 1)]);}
      vars__.emplace_back(sigma);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 8;
      phi = stan::math::negative_infinity();
      current_statement__ = 9;
      assign(k, cons_list(index_uni(1), nil_index_list()), 0,
        "assigning variable k");
      current_statement__ = 10;
      assign(k, cons_list(index_min_max(2, T), nil_index_list()), ks,
        "assigning variable k");
      current_statement__ = 12;
      if (logical_gt(family, 0)) {
        current_statement__ = 11;
        phi = inv(aux[(1 - 1)]);
      } 
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
          vars__.emplace_back(k[(sym1__ - 1)]);}
        vars__.emplace_back(phi);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> k_p;
      k_p = Eigen::Matrix<double, -1, 1>(Tfor);
      stan::math::fill(k_p, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> mufor;
      mufor = Eigen::Matrix<double, -1, 1>(L);
      stan::math::fill(mufor, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(log_lik_1dim__);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik2;
      log_lik2 = Eigen::Matrix<double, -1, 1>(log_lik2_1dim__);
      stan::math::fill(log_lik2, std::numeric_limits<double>::quiet_NaN());
      
      int pos;
      pos = std::numeric_limits<int>::min();
      
      current_statement__ = 17;
      pos = 1;
      int pos2;
      pos2 = std::numeric_limits<int>::min();
      
      current_statement__ = 18;
      pos2 = 1;
      int pos3;
      pos3 = std::numeric_limits<int>::min();
      
      current_statement__ = 19;
      pos3 = 1;
      current_statement__ = 20;
      assign(k_p, cons_list(index_uni(1), nil_index_list()),
        ((c + k[(T - 1)]) + (sigma * normal_rng(0, 1, base_rng__))),
        "assigning variable k_p");
      current_statement__ = 22;
      for (int t = 2; t <= Tfor; ++t) {
        current_statement__ = 21;
        assign(k_p, cons_list(index_uni(t), nil_index_list()),
          ((c + k_p[((t - 1) - 1)]) + (sigma * normal_rng(0, 1, base_rng__))),
          "assigning variable k_p");}
      current_statement__ = 62;
      if (logical_eq(family, 0)) {
        current_statement__ = 49;
        for (int t = 1; t <= Tfor; ++t) {
          current_statement__ = 48;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 45;
            assign(mufor, cons_list(index_uni(pos), nil_index_list()),
              (a[(x - 1)] + (b[(x - 1)] * k_p[(t - 1)])),
              "assigning variable mufor");
            current_statement__ = 46;
            pos = (pos + 1);}}
        current_statement__ = 50;
        assign(mufor, nil_index_list(),
          stan::math::exp(stan::model::deep_copy(mufor)),
          "assigning variable mufor");
        current_statement__ = 55;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 54;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 51;
            assign(log_lik, cons_list(index_uni(pos2), nil_index_list()),
              poisson_log_lpmf<false>(d[(pos2 - 1)],
                ((input_offset[(pos2 - 1)] + a[(x - 1)]) +
                  (b[(x - 1)] * k[(t - 1)]))), "assigning variable log_lik");
            current_statement__ = 52;
            pos2 = (pos2 + 1);}}
        current_statement__ = 60;
        for (int t = 1; t <= Tval; ++t) {
          current_statement__ = 59;
          for (int x = 1; x <= J; ++x) {
            current_statement__ = 56;
            assign(log_lik2, cons_list(index_uni(pos3), nil_index_list()),
              poisson_log_lpmf<false>(dval[(pos3 - 1)],
                ((offset2[(pos3 - 1)] + a[(x - 1)]) +
                  (b[(x - 1)] * k_p[(t - 1)]))),
              "assigning variable log_lik2");
            current_statement__ = 57;
            pos3 = (pos3 + 1);}}
      } else {
        current_statement__ = 44;
        if (logical_gt(family, 0)) {
          current_statement__ = 32;
          for (int t = 1; t <= Tfor; ++t) {
            current_statement__ = 31;
            for (int x = 1; x <= J; ++x) {
              current_statement__ = 29;
              if (logical_gt(
                    stan::math::abs(
                      (a[(x - 1)] + (b[(x - 1)] * k_p[(t - 1)]))), 15)) {
                current_statement__ = 26;
                assign(mufor, cons_list(index_uni(pos), nil_index_list()), 0,
                  "assigning variable mufor");
                current_statement__ = 27;
                pos = (pos + 1);
              } else {
                current_statement__ = 23;
                assign(mufor, cons_list(index_uni(pos), nil_index_list()),
                  gamma_rng(phi,
                    (phi /
                      stan::math::exp(
                        (a[(x - 1)] + (b[(x - 1)] * k_p[(t - 1)])))),
                    base_rng__), "assigning variable mufor");
                current_statement__ = 24;
                pos = (pos + 1);
              }}}
          current_statement__ = 37;
          for (int t = 1; t <= T; ++t) {
            current_statement__ = 36;
            for (int x = 1; x <= J; ++x) {
              current_statement__ = 33;
              assign(log_lik, cons_list(index_uni(pos2), nil_index_list()),
                neg_binomial_2_log_lpmf<false>(d[(pos2 - 1)],
                  ((input_offset[(pos2 - 1)] + a[(x - 1)]) +
                    (b[(x - 1)] * k[(t - 1)])), phi),
                "assigning variable log_lik");
              current_statement__ = 34;
              pos2 = (pos2 + 1);}}
          current_statement__ = 42;
          for (int t = 1; t <= Tval; ++t) {
            current_statement__ = 41;
            for (int x = 1; x <= J; ++x) {
              current_statement__ = 38;
              assign(log_lik2, cons_list(index_uni(pos3), nil_index_list()),
                neg_binomial_2_log_lpmf<false>(dval[(pos3 - 1)],
                  ((offset2[(pos3 - 1)] + a[(x - 1)]) +
                    (b[(x - 1)] * k_p[(t - 1)])), phi),
                "assigning variable log_lik2");
              current_statement__ = 39;
              pos3 = (pos3 + 1);}}
        } 
      }
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        vars__.emplace_back(k_p[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= L; ++sym1__) {
        vars__.emplace_back(mufor[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= log_lik2_1dim__; ++sym1__) {
        vars__.emplace_back(log_lik2[(sym1__ - 1)]);}
      vars__.emplace_back(pos);
      vars__.emplace_back(pos2);
      vars__.emplace_back(pos3);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<double> aux;
      aux = std::vector<double>(aux_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(aux, nil_index_list(), context__.vals_r("aux"),
        "assigning variable aux");
      std::vector<double> aux_free__;
      aux_free__ = std::vector<double>(aux_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(aux_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(aux[(sym1__ - 1)], 0),
          "assigning variable aux_free__");}
      Eigen::Matrix<double, -1, 1> a;
      a = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_flat__;
        current_statement__ = 2;
        assign(a_flat__, nil_index_list(), context__.vals_r("a"),
          "assigning variable a_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 2;
          assign(a, cons_list(index_uni(sym1__), nil_index_list()),
            a_flat__[(pos__ - 1)], "assigning variable a");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> b_flat__;
        current_statement__ = 3;
        assign(b_flat__, nil_index_list(), context__.vals_r("b"),
          "assigning variable b_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 3;
          assign(b, cons_list(index_uni(sym1__), nil_index_list()),
            b_flat__[(pos__ - 1)], "assigning variable b");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> b_free__;
      b_free__ = Eigen::Matrix<double, -1, 1>((J - 1));
      stan::math::fill(b_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(b_free__, nil_index_list(), stan::math::simplex_free(b),
        "assigning variable b_free__");
      double c;
      c = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      c = context__.vals_r("c")[(1 - 1)];
      Eigen::Matrix<double, -1, 1> ks;
      ks = Eigen::Matrix<double, -1, 1>(ks_1dim__);
      stan::math::fill(ks, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> ks_flat__;
        current_statement__ = 5;
        assign(ks_flat__, nil_index_list(), context__.vals_r("ks"),
          "assigning variable ks_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= ks_1dim__; ++sym1__) {
          current_statement__ = 5;
          assign(ks, cons_list(index_uni(sym1__), nil_index_list()),
            ks_flat__[(pos__ - 1)], "assigning variable ks");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
        vars__.emplace_back(aux_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(a[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= (J - 1); ++sym1__) {
        vars__.emplace_back(b_free__[(sym1__ - 1)]);}
      vars__.emplace_back(c);
      for (int sym1__ = 1; sym1__ <= ks_1dim__; ++sym1__) {
        vars__.emplace_back(ks[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("aux");
    names__.emplace_back("a");
    names__.emplace_back("b");
    names__.emplace_back("c");
    names__.emplace_back("ks");
    names__.emplace_back("sigma");
    names__.emplace_back("k");
    names__.emplace_back("phi");
    names__.emplace_back("k_p");
    names__.emplace_back("mufor");
    names__.emplace_back("log_lik");
    names__.emplace_back("log_lik2");
    names__.emplace_back("pos");
    names__.emplace_back("pos2");
    names__.emplace_back("pos3");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(aux_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ks_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Tfor)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(L)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(log_lik_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(log_lik2_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "aux" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "c");
    for (int sym1__ = 1; sym1__ <= ks_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "ks" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "phi");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= L; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mufor" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik2_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik2" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "pos");
      param_names__.emplace_back(std::string() + "pos2");
      param_names__.emplace_back(std::string() + "pos3");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= aux_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "aux" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (J - 1); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "c");
    for (int sym1__ = 1; sym1__ <= ks_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "ks" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "phi");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= Tfor; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "k_p" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= L; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mufor" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= log_lik2_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik2" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "pos");
      param_names__.emplace_back(std::string() + "pos2");
      param_names__.emplace_back(std::string() + "pos3");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"aux\",\"type\":{\"name\":\"array\",\"length\":" << aux_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"c\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"ks\",\"type\":{\"name\":\"vector\",\"length\":" << ks_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"k_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"mufor\",\"type\":{\"name\":\"vector\",\"length\":" << L << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik2\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik2_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"pos\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos2\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos3\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"aux\",\"type\":{\"name\":\"array\",\"length\":" << aux_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << (J - 1) << "},\"block\":\"parameters\"},{\"name\":\"c\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"ks\",\"type\":{\"name\":\"vector\",\"length\":" << ks_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"k_p\",\"type\":{\"name\":\"vector\",\"length\":" << Tfor << "},\"block\":\"generated_quantities\"},{\"name\":\"mufor\",\"type\":{\"name\":\"vector\",\"length\":" << L << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik2\",\"type\":{\"name\":\"vector\",\"length\":" << log_lik2_1dim__ << "},\"block\":\"generated_quantities\"},{\"name\":\"pos\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos2\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"},{\"name\":\"pos3\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_leecarter_namespace::model_leecarter;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_leecarter_namespace::profiles__;
}
#endif
#endif
