% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G.spillover.R
\name{G.spillover}
\alias{G.spillover}
\title{Generalized spillover index}
\usage{
G.spillover(x, n.ahead = 10, standardized = TRUE)
}
\arguments{
\item{x}{Object of class \sQuote{\code{varest}} generated by \code{VAR()}.}

\item{n.ahead}{Integer specifying the steps ahead.}

\item{standardized}{A logical value indicating whether the values should be divided by the number of columns
to get a percentage.}
}
\value{
A \code{data.frame} consisting of the spillover index.
}
\description{
Computes the generalized spillover index proposed in Diebold and Yilmaz (2012) 
which is based on the General Forecast Variance Decompositon introduced by Pesaran and Shin (1998).
}
\details{
This function computes the Generalized Directional Spillover Table which has as its
\eqn{ij^{th}}{ij^th} entry the estimated contribution \emph{to} the forecast error variance 
of variable \emph{i} coming \emph{from} innovations to variable \emph{j}. The off-diagonal
column sums are the \emph{Contributions to Others}, while the row sums represent 
\emph{Contributions from Others}, when these are totaled across  countries then we have
the numerator of the Spillover Index. Similarly, the columns sums or rows sums 
(including diagonal), when totaled across countries, give the denominator of the 
Spillover Index, which is 100\%.
   
\code{G.spillover} is based upon the General Forecast Error Variance Decompositon introduced by 
Pesaran and Shin (1998) and its explicit formulation can be found in Diebold and Yilmaz (2010).
}
\examples{
# Replicating Diebold and Yilmaz (2012)
data(dy2012)
VAR_4 <- VAR(dy2012[,-1], p=4) 
G.spillover(VAR_4, standardized = FALSE)
}
\references{
Diebold, F. X. & Yilmaz, K.(2012). \emph{Better to Give than to Receive: Predictive Directional Measurement of Volatility Spillovers}. International Journal of Forecasting.

Pesaran, M. H. and Shin, Y. (1998). \emph{Generalized impulse response analysis in linear multivariate models}. Economics Letters, 58(1):17-29.
}
\seealso{
\code{\link{O.spillover}}
}
\author{
Jilber Urbina
}
\keyword{models}
\keyword{regression}
