% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stsum}
\alias{stsum}
\title{Standardize a symmetric matrix (distances) to fixed row (column) totals}
\usage{
stsum(mat, vec, differ = 1e-15, niter = 1000L)
}
\arguments{
\item{mat}{A distance matrix size NxN.}

\item{vec}{A vector of row (column) constraints.}

\item{differ}{A scalar with the maximum accepted difference with the constraint (default = 1e-15).}

\item{niter}{An integer with the maximum number of iterations (default = 1000).}
}
\value{
Returns a standardized distance matrix of size NxN.
}
\description{
Standardizes a distance matrix to fixed rows and columns
totals. The function iteratively constrains the rows sums of the matrix
to know totals, and in order to keep the symmetry of the matrix, at each
iteration performs an average with its transpose. When the known totals are
all equal to a constant (e.g. 1), this method provides a simple and
accurate way to scale a distance matrix to a doubly stochastic matrix.
}
\details{
The standardized matrix will not be affected by problems arising from units
with different inclusion probabilities caused by undesired features of the
spatial distribution of the population, as edge effects and/or isolated
points.
}
\examples{
dis <- as.matrix(dist(cbind(simul2$x, simul2$y))) # distance matrix
con <- rep(1, nrow(dis)) # vector of constraints
stand_dist <- stsum(mat = dis, vec = con) # standardized matrix
}
\references{
Benedetti R, Piersimoni F (2017). A spatially balanced design with
probability function proportional to the within sample distance.
\emph{Biometrical Journal}, \strong{59}(5), 1067-1084.
\url{https://doi.org/10.1002/bimj.201600194}
}
