% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pwd}
\alias{pwd}
\title{Product Within Distance (Spatially Balanced Sampling Design)}
\usage{
pwd(dis, nsamp, nrepl = 1L, niter = 10L)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far are all the pairs
of units in the population.}

\item{nsamp}{Sample size.}

\item{nrepl}{Number of samples to draw (default = 1).}

\item{niter}{Number of iterations for the algorithm. More iterations are
better but require more time. Usually 10 is very efficient (default = 10).}
}
\value{
Return a matrix \code{nrepl} x \code{nsamp}, which contains the
\code{nrepl} selected samples, each of them stored in a row. In particular,
the i-th row contains all labels of units selected in the i-th sample.
}
\description{
Selects spatially balanced samples through the use of the
Product Within Distance design (PWD). The level of the spread can be
choosen through the parameter \eqn{\beta}, which is regulated by the
exponent of the distance matrix (D^1 -> \eqn{\beta = 1},
D^10 -> \eqn{\beta = 10}). The higher \eqn{\beta} is, the more the sample
is going to be spread. To have constant inclusion probabilities
\eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is
population size, the distance matrix has to be standardized with function
\code{\link{stprod}}.
}
\examples{
# Example 1
# Draw 20 samples of dimension 15 without constant probabilities and with beta = 1
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
nsamp <- 15  # sample size
nrepl <- 20  # number of samples to draw
niter <- 10  # number of iterations in the algorithm
samples <- pwd(dis, niter, nsamp, nrepl)  # drawn samples
\donttest{
# Example 2
# Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N
# with N = population size
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
nsamp <- 15  # sample size
nrepl <- 20  # number of samples to draw
niter <- 10  # number of iterations in the algorithm
vec <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(dis, vec ,1e-15 ,1000) # standardized matrix
samples <- pwd(stand_dist, niter, nsamp, nrepl)  # drawn samples

# Example 3
# Draw 20 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 10
# with N = population size
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
dis <- dis^10 # setting beta = 10
nsamp <- 15  # sample size
nrepl <- 20  # number of samples to draw
niter <- 10  # number of iterations in the algorithm
vec <- rep(0, nrow(dis)) # vector of constraints
stand_dist <- stprod(dis, vec, 1e-15, 1000) # standardized matrix
samples <- pwd(stand_dist, niter, nsamp, nrepl)  # drawn samples
}
}
\references{
Benedetti R, Piersimoni F (2017). “A spatially balanced design with
probability function proportional to the within sample distance.”
\emph{Biometrical Journal}, \strong{59}(5), 1067–1084.
}
