% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{eigenFunction}
\alias{eigenFunction}
\title{Interpolated Eigen-function}
\usage{
eigenFunction(new_location, original_location, Phi)
}
\arguments{
\item{new_location}{A location matrix}

\item{original_location}{A location matrix}

\item{Phi}{An eigenvector matrix}
}
\value{
A predictive estimte matrix
}
\description{
Produce Eigen-function values based on new locations
}
\examples{
pesudo_sequence <- seq(-5, 5, length = 2)
original_location <- as.matrix(expand.grid(x = pesudo_sequence, y = pesudo_sequence))
new_location <- matrix(c(0.1, 0.2), nrow = 1, ncol = 2)
Phi <- matrix(c(1, 0, 0, 0), nrow = 4, ncol = 1)
thin_plate_matrix <- eigenFunction(new_location, original_location, Phi)
}
\keyword{internal}
