% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sparse_chol}
\alias{sparse_chol}
\title{Sparse Cholesky decomposition}
\usage{
sparse_chol(mat)
}
\arguments{
\item{mat}{A matrix}
}
\value{
A lower-triangular matrix.
}
\description{
Sparse Cholesky decomposition
}
\details{
Generates the LDL decomposition of a symmetric, sparse matrix using the method 
described by Timothy Davis (see references). This function accepts a standard matrix,
converts to sparse format, generates the LDL decomposition and returns the Cholesky 
decomposition LD^0.5.
}
\examples{
M <- diag(10)
#put a few random values in
M[lower.tri(M)][seq(1,45,by=5)] <- c(0.1,0.5,0.9,0.6,0.8,0.9,0.2,0.3,0.1)
M[upper.tri(M)][seq(1,45,by=5)] <- c(0.1,0.5,0.9,0.6,0.8,0.9,0.2,0.3,0.1)
L <- sparse_chol(M)
}
