% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{read.jdbc}
\alias{read.jdbc}
\title{Create a SparkDataFrame representing the database table accessible via JDBC URL}
\usage{
read.jdbc(url, tableName, partitionColumn = NULL, lowerBound = NULL,
  upperBound = NULL, numPartitions = 0L, predicates = list(), ...)
}
\arguments{
\item{url}{JDBC database url of the form \code{jdbc:subprotocol:subname}}

\item{tableName}{the name of the table in the external database}

\item{partitionColumn}{the name of a column of integral type that will be used for partitioning}

\item{lowerBound}{the minimum value of \code{partitionColumn} used to decide partition stride}

\item{upperBound}{the maximum value of \code{partitionColumn} used to decide partition stride}

\item{numPartitions}{the number of partitions, This, along with \code{lowerBound} (inclusive),
\code{upperBound} (exclusive), form partition strides for generated WHERE
clause expressions used to split the column \code{partitionColumn} evenly.
This defaults to SparkContext.defaultParallelism when unset.}

\item{predicates}{a list of conditions in the where clause; each one defines one partition}

\item{...}{additional JDBC database connection named properties.}
}
\value{
SparkDataFrame
}
\description{
Additional JDBC database connection properties can be set (...)
}
\details{
Only one of partitionColumn or predicates should be set. Partitions of the table will be
retrieved in parallel based on the \code{numPartitions} or by the predicates.

Don't create too many partitions in parallel on a large cluster; otherwise Spark might crash
your external database systems.
}
\note{
read.jdbc since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
jdbcUrl <- "jdbc:mysql://localhost:3306/databasename"
df <- read.jdbc(jdbcUrl, "table", predicates = list("field<=123"), user = "username")
df2 <- read.jdbc(jdbcUrl, "table2", partitionColumn = "index", lowerBound = 0,
                 upperBound = 10000, user = "username", password = "password")
}
}
