% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_fpm.R
\docType{methods}
\name{spark.fpGrowth}
\alias{spark.fpGrowth}
\alias{spark.freqItemsets}
\alias{spark.associationRules}
\alias{spark.fpGrowth}
\alias{spark.fpGrowth,SparkDataFrame-method}
\alias{spark.freqItemsets,FPGrowthModel-method}
\alias{freqItemsets,FPGrowthModel-method}
\alias{spark.associationRules,FPGrowthModel-method}
\alias{associationRules,FPGrowthModel-method}
\alias{predict,FPGrowthModel-method}
\alias{write.ml,FPGrowthModel,character-method}
\title{FP-growth}
\usage{
spark.fpGrowth(data, ...)

spark.freqItemsets(object)

spark.associationRules(object)

\S4method{spark.fpGrowth}{SparkDataFrame}(data, minSupport = 0.3,
  minConfidence = 0.8, itemsCol = "items", numPartitions = NULL)

\S4method{spark.freqItemsets}{FPGrowthModel}(object)

\S4method{spark.associationRules}{FPGrowthModel}(object)

\S4method{predict}{FPGrowthModel}(object, newData)

\S4method{write.ml}{FPGrowthModel,character}(object, path, overwrite = FALSE)
}
\arguments{
\item{data}{A SparkDataFrame for training.}

\item{...}{additional argument(s) passed to the method.}

\item{object}{a fitted FPGrowth model.}

\item{minSupport}{Minimal support level.}

\item{minConfidence}{Minimal confidence level.}

\item{itemsCol}{Features column name.}

\item{numPartitions}{Number of partitions used for fitting.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{the directory where the model is saved.}

\item{overwrite}{logical value indicating whether to overwrite if the output path
already exists. Default is FALSE which means throw exception
if the output path exists.}
}
\value{
\code{spark.fpGrowth} returns a fitted FPGrowth model.

A \code{SparkDataFrame} with frequent itemsets.
        The \code{SparkDataFrame} contains two columns:
        \code{items} (an array of the same type as the input column)
        and \code{freq} (frequency of the itemset).

A \code{SparkDataFrame} with association rules.
        The \code{SparkDataFrame} contains three columns:
        \code{antecedent} (an array of the same type as the input column),
        \code{consequent} (an array of the same type as the input column),
        and \code{condfidence} (confidence).

\code{predict} returns a SparkDataFrame containing predicted values.
}
\description{
A parallel FP-growth algorithm to mine frequent itemsets.
\code{spark.fpGrowth} fits a FP-growth model on a SparkDataFrame. Users can
\code{spark.freqItemsets} to get frequent itemsets, \code{spark.associationRules} to get
association rules, \code{predict} to make predictions on new data based on generated association
rules, and \code{write.ml}/\code{read.ml} to save/load fitted models.
For more details, see
\href{https://spark.apache.org/docs/latest/mllib-frequent-pattern-mining.html#fp-growth}{
FP-growth}.
}
\note{
spark.fpGrowth since 2.2.0

spark.freqItemsets(FPGrowthModel) since 2.2.0

spark.associationRules(FPGrowthModel) since 2.2.0

predict(FPGrowthModel) since 2.2.0

write.ml(FPGrowthModel, character) since 2.2.0
}
\examples{
\dontrun{
raw_data <- read.df(
  "data/mllib/sample_fpgrowth.txt",
  source = "csv",
  schema = structType(structField("raw_items", "string")))

data <- selectExpr(raw_data, "split(raw_items, ' ') as items")
model <- spark.fpGrowth(data)

# Show frequent itemsets
frequent_itemsets <- spark.freqItemsets(model)
showDF(frequent_itemsets)

# Show association rules
association_rules <- spark.associationRules(model)
showDF(association_rules)

# Predict on new data
new_itemsets <- data.frame(items = c("t", "t,s"))
new_data <- selectExpr(createDataFrame(new_itemsets), "split(items, ',') as items")
predict(model, new_data)

# Save and load model
path <- "/path/to/model"
write.ml(model, path)
read.ml(path)

# Optional arguments
baskets_data <- selectExpr(createDataFrame(itemsets), "split(items, ',') as baskets")
another_model <- spark.fpGrowth(data, minSupport = 0.1, minConfidence = 0.5,
                                itemsCol = "baskets", numPartitions = 10)
}
}
\seealso{
\link{read.ml}
}
